 
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Print QR Codes</title>
  <style>
    @media print {
      @page {
        size: A4;
        margin: 10mm;
      }
      body {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
        text-align: center;
      }
      .container {
        display: grid;
        grid-template-columns: repeat(5, 1fr); /* 5 QR codes per row */
        gap: 7mm; /* Gap between QR codes */
        justify-items: center;
        align-items: center;
      }
      .qr-code {
        width: 20mm;  /* Adjust width for smaller QR */
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      .qr-code img {
        width: 100%;
        height: auto;
      }
      .qr-code .text {
        margin-top: 1mm;
        font-size: 8px;
        font-weight: bold;
      }
    }
  </style>
</head>
<body onload="window.print();">
  <div class="container">
    <?php
    if (isset($_GET['string']) && isset($_GET['qty'])) {
        $text = $_GET['string'];
        $eng_p = $_GET['eng_p_name'];
        $qty = (int)$_GET['qty'];
 
        include 'barcode/phpqrcode/qrlib.php';
        
        $randomNumber = rand(10000, 99999);

        $file = "barcode/qr_$randomNumber.png";
            // Using a smaller pixel size for a smaller QR code
        QRcode::png($eng_p, $file, 'M', 4, 0);
            
        for ($i = 0; $i < $qty; $i++) {
    
            echo '<div class="qr-code">
                    <img src="'.$file.'" alt="QR Code">
                    <div class="text">'.$text.'</div>
                  </div>';
        }
    } else {
        echo '<p>Error: Missing parameters.</p>';
    }
    ?>
  </div>
</body>
</html>