<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Print QR Code</title>
    <style>
        @media print {
            body {
                margin: 0;
                padding: 0;
                width: 80mm; /* Standard thermal printer width */
                font-family: Arial, sans-serif; /* Readable font */
                text-align: center;
            }
            .container {
                width: 100%;
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                align-items: flex-start;
                page-break-inside: avoid; /* Prevents extra blank pages */
            }
            .row {
                display: flex;
                justify-content: space-between;
                width: 900%;
                gap: 8mm; /* Ensures space between QR codes */
                margin-bottom: 7mm; /* Space between rows */
                page-break-inside: avoid; /* Prevents breaking between rows */
            }
            .qr-code {
                width: 48%; /* Each QR code takes half the width */
                text-align: center;
                padding: 0;
            }
            img {
                width: 36mm; /* Adjusted QR code size */
                height: 36mm; /* Ensures no extra paper usage */
                display: block;
            }
            .text {
                font-size: 13px; /* Optimized text size */
                font-weight: bold;
                display: block;
                margin-top: 1mm;
            }
        }
    </style>
</head>
<body onload="window.print();">

<?php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

if (isset($_GET["string"]) && isset($_GET["qty"])) {
    $text = $_GET["string"];
    $qty = (int)$_GET["qty"];

    include 'barcode/phpqrcode/qrlib.php'; 


    $randomNumber = rand(100, 999);
 
    // File path for saving the QR code
    $file = "barcode/$randomNumber.png";
    // QR code settings
    $ecc = 'M'; // Medium error correction for better print quality
    $pixel_size = 10; // Adjusted QR code size
    $frame_size = 0;

    // Generate QR Code and Save as PNG
    QRcode::png($text, $file, $ecc, $pixel_size, $frame_size);

    echo '<div class="container">';
    
    for ($i = 0; $i < $qty; $i += 2) {
        echo '<div class="row">';
        
        // First QR code in the row
        echo '<div class="qr-code">
                <img src="'.$file.'" alt="QR Code">
                <span class="text">'.$text.'</span>
              </div>';

        // Second QR code in the row (if available)
        if ($i + 1 < $qty) {
            echo '<div class="qr-code">
                    <img src="'.$file.'" alt="QR Code">
                    <span class="text">'.$text.'</span>
                  </div>';
        }

        echo '</div>'; // Close row
    }
    
    echo '</div>'; // Close container
} else {
    echo '<p>Error: Missing parameters.</p>';
}
?>

</body>
</html>
