<?php
require 'db.php';
header('Access-Control-Allow-Origin: *');
require 'tcpdf/tcpdf.php';


// ini_set('display_errors', 1);
// error_reporting(E_ALL);
 

function convertNumberToIndianCurrencyWords($number) {
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' rupees and ';
    $dictionary  = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'forty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        100000              => 'lakh',
        10000000            => 'crore'
    );
    
    if (!is_numeric($number)) {
        return false;
    }
    
    // Handle negative numbers
    if ($number < 0) {
        return $negative . convertNumberToIndianCurrencyWords(abs($number));
    }
    
    // Split integer and decimal parts
    $integerPart = (int) $number;
    $fractionalPart = null;
    if (strpos((string)$number, '.') !== false) {
        $fractionalPart = explode('.', (string)$number)[1];
    }

    $string = '';
    
    // Handle zero case
    if ($integerPart == 0) {
        $string = $dictionary[0];
    }
    
    // Convert integer part
    else {
        $string = convertIntegerToIndianWords($integerPart, $dictionary, $hyphen, $conjunction, $separator);
    }
    
    // Convert fractional part (if exists)
    if ($fractionalPart !== null && is_numeric($fractionalPart)) {
        $string .= $decimal;
        $fractionalDigits = str_split($fractionalPart);
        foreach ($fractionalDigits as $digit) {
            $string .= $dictionary[$digit] . ' ';
        }
        $string .= 'paise';
    } else {
        $string .= ' rupees';
    }
    
    return trim($string);
}

function convertIntegerToIndianWords($number, $dictionary, $hyphen, $conjunction, $separator) {
    if ($number < 21) {
        return $dictionary[$number];
    } elseif ($number < 100) {
        $tens   = ((int) ($number / 10)) * 10;
        $units  = $number % 10;
        $string = $dictionary[$tens];
        if ($units) {
            $string .= $hyphen . $dictionary[$units];
        }
        return $string;
    } elseif ($number < 1000) {
        $hundreds  = $number / 100;
        $remainder = $number % 100;
        $string = $dictionary[(int)$hundreds] . ' ' . $dictionary[100];
        if ($remainder) {
            $string .= $conjunction . convertIntegerToIndianWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
        }
        return $string;
    } else {
        foreach (array_reverse($dictionary, true) as $value => $word) {
            if ($number >= $value) {
                $numberOfWords = (int)($number / $value);
                $remainder = $number % $value;
                $string = convertIntegerToIndianWords($numberOfWords, $dictionary, $hyphen, $conjunction, $separator) . ' ' . $word;
                if ($remainder) {
                    $string .= $remainder < 100 ? $conjunction : $separator;
                    $string .= convertIntegerToIndianWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
                }
                return $string;
            }
        }
    }
}

      
  if($_GET['custType'] != 'Wholesale'){
      
      class MYPDF extends TCPDF {
    // Page header
    public function Header() {
        // Leave empty for now or customize it further.
    }

    // Page footer
    public function Footer() {
        $this->SetY(-15);
       // $this->SetFont('helvetica', 'I', 8);
        $pdf->AddFont('NotoSansDevanagari', '', 'NotoSansDevanagari-Regular.ttf', true);
        $pdf->SetFont('NotoSansDevanagari', '', 12);

        
        
        
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'C');
    }
}

// Create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetMargins(10, 20, 10, 10);
$pdf->SetAutoPageBreak(TRUE, 15);
$pdf->AddPage('P');

// Fetch client and order details from database
$client_no = $_GET['id'];
  $order_no = $_GET['order_no'];
$user = htmlspecialchars($_GET['user'], ENT_QUOTES, 'UTF-8');

// Fetch client details
$sql = "SELECT * FROM clients WHERE client_no='$client_no'";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    $client = $result->fetch_assoc();

    // Fetch sales order details
     $sql1 = "SELECT s.*,c.c_cont,c.c_add FROM sales s left join customer c ON s.patient_no = c.c_no WHERE s.order_no = '". $_GET['order_no']."' ";
    $result1 = $conn->query($sql1);
    if ($result1->num_rows > 0) {
        $order = $result1->fetch_assoc();

        // Start building the HTML content
        $html = '<style>
            
             
        </style>';

        // Header information
   
        
        $html .= '
        
        
        <table style="border: 1px solid black;padding:2px;margin:10px; ">
            <tr>
                <td style="width: 20%; text-align: center;" rowspan="5">';
        $pdf->Image('@'.file_get_contents('https://'.$_SERVER['SERVER_NAME'].'/server/upload/smartpharma.png'), 15, 25, 30);
        $html .= '</td>
                <td style="width: 50%; text-align: center; font-size: 9px;"><b>GST TAX INVOICE</b></td>
                <td style="width: 7%; text-align: left; font-size: 7px;"><b>GST No.</b></td>
                <td style="width: 23%; text-align: left; font-size: 7px;"><b>: </b> ' . $client['gst_no'] . '</td>
            </tr>
            <tr>
                <td style="width: 50%; text-align: center; font-size: 11px;"><b>' . $client['medical'] . '</b></td>
                 <td style="width: 7%; text-align: left; font-size: 7px;"><b>DI. No.</b></td>
                <td style="width: 23%; text-align: left; font-size: 7px;"><b>:</b> ' . $client['dl1'] . ',  ' . $client['dl2'] . '</td>
            </tr>
            <tr>
                <td style="width: 50%; text-align: center; font-size: 8px;" rowspan="3">' . $client['address'] . ' </td>
                <td style="width: 7%; text-align: left; font-size: 7px;"><b>PH. No.</b></td>
                <td style="width: 23%; text-align: left; font-size: 7px;"><b>:</b>  ' . $client['mobile'] . '</td>
            </tr>
         
            <tr>
                 <td style="width: 7%; text-align: left; font-size: 7px;"><b>Email</b></td>
                 <td style="width: 23%; text-align: left; font-size: 7px;"><b>:</b>  ' . $client['email'] . '</td>
            </tr>
        </table>
         <div></div>';
        
        
        
        if($order['billType'] == 'Retail'){
        
        
        
        
         $html .= '
        
        <table style="border: 1px solid black;padding:2px;margin:10px; ">
         
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Patient Name </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' . $order['patient_name'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Invoice No. </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' . $order['order_no'] . '</td>
             </tr>
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Dr. Name </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' . $order['doctor_name'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Inv. Date </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' .date('d-m-Y', strtotime( $order['order_date'])) . '</td>
             </tr>
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Patient No. </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' . $order['c_cont'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Pat. Address </b></td>
                 <td style="width: 4%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 35%; text-align: left; font-size: 7px;">' . $order['c_add'] . '</td>
             </tr>
     
        </table>
        
        
        
        <table style="padding:4px;" >
            <tr >
              <th style="border: 1px solid black;width: 150px; font-weight: bold; text-align: left; font-size: 7px;">Product</th>
              <th style="border: 1px solid black;width: 40px; font-weight: bold; text-align: center; font-size: 7px;">HSN</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">B.No</th>
              <th style="border: 1px solid black;width: 35px; font-weight: bold; text-align: center; font-size: 7px;">Exp.</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">Qty</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">Pack</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">MRP</th>
              <th style="border: 1px solid black;width: 44px; font-weight: bold; text-align: center; font-size: 7px;">Gross</th>
              <th style="border: 1px solid black;width: 35px; font-weight: bold; text-align: center; font-size: 7px;">Disc</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">GST</th>
              <th style="border: 1px solid black;width: 44px; font-weight: bold; text-align: center; font-size: 7px;">Net</th>
            </tr>
          
        ';

        // Fetch product details
        $sql2 = "SELECT * FROM sale_products WHERE order_no='$order_no'";
        $result2 = $conn->query($sql2);
        if ($result2->num_rows > 0) {
            while ($row2 = $result2->fetch_assoc()) {
                $exp_date = explode('-', $row2['exp_date']);
                $formatted_exp_date = $exp_date[1] . '/' . substr($exp_date[0], -2);

                $html .= '<tr >
                    <td style="border: 1px solid black; text-align: left; font-size:   7px;">' . substr($row2['m_name'], 0, 3) . ' - ' . $row2['p_name'] . '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['hsn'] . '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['batch_no'] . '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .$formatted_exp_date. '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['qty'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['pack_size'] . '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['mrp'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['taxable'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . number_format($row2['disc_amt'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['gst'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . number_format($row2['net'], 2). '</td>
                </tr>';
               
            }
        }

         $html .= '
          </table> 
          <table style="border: 1px solid black;padding:2px;margin:10px; ">
         
        <tr>
            <td style="border: 1px solid black; width: 377px; text-align: left; font-size:7px;" rowspan="5">
            <span style="text-align: left;font-weight: bolder; font-size: 7px;">Amt. In Words </span>
            <span style="text-align: left;font-weight: bolder; font-size: 7px; color:green;text-transform: uppercase;">: ' .convertNumberToIndianCurrencyWords($order['net']) . '  Only</span><br>
            <span style="text-align: left;font-weight: bolder; font-size: 7px;">Credit Bal.</span>
            <span style="text-align: left;font-weight: bolder; font-size: 7px; color:green;">:' . number_format($order['net'], 2). '</span><br>
            <b>Terms & Conditions</b>
             
            <ol>
                <li style="font-weight: bolder; font-size: 7px;"> Medicine return shall be done within 7 days of purchase.</li>
                <li style="font-weight: bolder; font-size: 7px;"> Cut strips, Refrigerated, OTC/FMCG shall not be refunded/exchanged.</li>
                <li style="font-weight: bolder; font-size: 7px;"> No return/Exchange will be processed without presenting the original bill.</li>
            </ol>
            
            </td>
      
            <td style=" width: 79px; text-align: left; font-size: 7px;">GROSS</td>
            <td style=" width: 82px; text-align: left; font-size: 7px;">' . number_format($order['taxable'], 2). '</td>
        </tr>
        <tr >       
            <td style=" width: 79px; text-align: left; font-size: 7px;">DISCOUNT</td>
            <td style=" width: 82px; text-align: left; font-size: 7px;">' . number_format($order['discount'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: left; font-size: 7px;">TAX</td>
            <td style="width: 82px; text-align: left; font-size: 7px;">' . number_format($order['gst'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: left; font-size: 7px;"></td>
            <td style="width: 82px; text-align: left; font-size: 7px;"></td>
        </tr>
        
        <tr >       
            <td style="border: 1px solid black; width: 79px; text-align: left;font-weight: bolder; font-size: 9px; ">NET AMT.</td>
            <td style="border: 1px solid black; width: 82px; text-align: left;font-weight: bolder; font-size: 9px; color:green;">' . number_format(round($order['net']), 2). '</td>
        </tr>        
        <tr>
            <td style="border: 1px solid black; width: 377px; text-align: left; font-size:7px;">
                <span style="text-align: left;font-weight: bolder; font-size: 11px;">' . $client['medical'] . '</span><br><br>
                <span style="text-align: left;  font-size: 8px;">' . $client['address'] . '</span><br><br>
                <span style="text-align: left;font-weight: bolder; font-size: 8px;">Customer Care </span> 
                <span style="text-align: left;font-weight: bolder; font-size: 8px;">: ' . $client['mobile'] . '</span><br>
            </td>
      
             <td style=" width: 152px; text-align: center; font-size: 8px;font-weight: bolder;">
             
             REG. PHARMCIST SIGN <br>
             ' . $order['entry_by'] . ' <br>
                <img src="../prescriptions/stamp/' . $client['stampFile'] .'"  style="width: 200px; height: 100px;" >
             </td>
        </tr>
        
 
    </table>';

        // Final comments
        $html .= '<br><br><table>
            <tr>
                <td style="width: 100%; font-weight: bold;">Get Well Soon !!!</td>
                
            </tr>
        </table>';
        
        
        }
        
        
        else if($order['billType'] == 'IPD'){
        
         
        
         $html .= '
        
        <table style="border: 1px solid black;padding:2px;margin:10px; ">
         
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Patient Name </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . $order['patient_name'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Invoice No. </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . $order['order_no'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Dr. Name </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                <td style="width: 21%; text-align: left; font-size: 7px;">' . $order['doctor_name'] . '</td>

            </tr>
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Inv. Date </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . date('d-m-Y', strtotime($order['order_date'])) . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Pat./ Relat. No. </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . $order['c_cont'] . ' / ' . $order['relativePhNo'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Hospital Name </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 21%; text-align: left; font-size: 7px;">' . $order['hospName'] . '</td>

            </tr>
            <tr>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Pat. Address </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . $order['c_add'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Ward No. </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 20%; text-align: left; font-size: 7px;">' . $order['wardNo'] . '</td>
                 <td style="width: 11%; text-align: left; font-size: 7px;"> <b> Bed No. </b></td>
                 <td style="width: 2%; text-align: center; font-size: 7px;"><b>:</b></td>
                 <td style="width: 21%; text-align: left; font-size: 7px;">' . $order['bedNo'] . '</td>
         
             </tr>
     
        </table>
       
       <div></div>
        
        <table style="padding:4px; border: 1px solid black;">
            <tr >
              <th style="border: 1px solid black;width: 50px; font-weight: bold; text-align: left; font-size: 7px;">Date</th>
              <th style="border: 1px solid black;width: 150px; font-weight: bold; text-align: left; font-size: 7px;">Product</th>
               <th style="border: 1px solid black;width: 32px; font-weight: bold; text-align: right; font-size: 7px;">Exp.</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: right; font-size: 7px;">Qty</th>
               <th style="border: 1px solid black;width: 50px; font-weight: bold; text-align: right; font-size: 7px;">MRP</th>
              <th style="border: 1px solid black;width: 65px; font-weight: bold; text-align: right; font-size: 7px;">Gross</th>
              <th style="border: 1px solid black;width: 45px; font-weight: bold; text-align: right; font-size: 7px;">Disc</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: right; font-size: 7px;">GST</th>
              <th style="border: 1px solid black;width: 70px; font-weight: bold; text-align: right; font-size: 7px;">Net</th>
            </tr>
          
        ';

        // Fetch product details
        $sql2 = "SELECT * FROM sale_products WHERE order_no='$order_no'";
        $result2 = $conn->query($sql2);
        if ($result2->num_rows > 0) {
            while ($row2 = $result2->fetch_assoc()) {
                $exp_date = explode('-', $row2['exp_date']);
                $formatted_exp_date = $exp_date[1] . '/' . substr($exp_date[0], -2);

                $html .= '<tr >
                    <td style=" text-align: left; font-size:   7px;">' . date('d-m-Y', strtotime($row2['order_date'])) . '</td>
                    <td style=" text-align: left; font-size:   7px;font-weight: bold;">' . substr($row2['m_name'], 0, 3) . ' - ' . $row2['p_name'] . '</td>
                     <td style=" text-align: right; font-size: 7px;">' .$formatted_exp_date. '</td>
                    <td style=" text-align: right; font-size: 7px;">' .number_format($row2['qty'], 2). '</td>
                     <td style=" text-align: right; font-size: 7px;">' .number_format($row2['mrp'], 2). '</td>
                    <td style=" text-align: right; font-size: 7px;">' .number_format($row2['taxable'], 2). '</td>
                    <td style=" text-align: right; font-size: 7px;">' . number_format($row2['disc_amt'], 2). '</td>
                    <td style=" text-align: right; font-size: 7px;">' .number_format($row2['gst'], 2). '</td>
                    <td style=" text-align: right; font-size: 7px;">' . number_format($row2['net'], 2). '</td>
                </tr>';
               
            }
        }

         $html .= '
          </table> 
          <table style="border: 1px solid black;padding:2px;margin:10px; ">
         
        <tr>
            <td style="border: 1px solid black; width: 377px; text-align: left; font-size:7px;" rowspan="5">
            <span style="text-align: left;font-weight: bolder; font-size: 7px;">Amt. In Words </span>
            <span style="text-align: left;font-weight: bolder; font-size: 7px; color:green;text-transform: uppercase;">: ' .convertNumberToIndianCurrencyWords($order['net']) . '  Only</span><br>
            <span style="text-align: left;font-weight: bolder; font-size: 7px;">Credit Bal.</span>
            <span style="text-align: left;font-weight: bolder; font-size: 7px; color:green;">:' . number_format($order['net'], 2). '</span><br>
            <b>Terms & Conditions</b>
             
            <ol>
                <li style="font-weight: bolder; font-size: 7px;"> Medicine return shall be done within 7 days of purchase.</li>
                <li style="font-weight: bolder; font-size: 7px;"> Cut strips, Refrigerated, OTC/FMCG shall not be refunded/exchanged.</li>
                <li style="font-weight: bolder; font-size: 7px;"> No return/Exchange will be processed without presenting the original bill.</li>
            </ol>
            
            </td>
      
            <td style=" width: 79px; text-align: right; font-size: 7px;">GROSS</td>
            <td style=" width: 82px; text-align: right; font-size: 7px;">' . number_format($order['taxable'], 2). '</td>
        </tr>
        <tr >       
            <td style=" width: 79px; text-align: right; font-size: 7px;">DISCOUNT</td>
            <td style=" width: 82px; text-align: right; font-size: 7px;">' . number_format($order['discount'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: right; font-size: 7px;">TAX</td>
            <td style="width: 82px; text-align: right; font-size: 7px;">' . number_format($order['gst'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: left; font-size: 7px;"></td>
            <td style="width: 82px; text-align: left; font-size: 7px;"></td>
        </tr>
        
        <tr >       
            <td style="border: 1px solid black; width: 79px; text-align: right;font-weight: bolder; font-size: 9px; ">NET AMT.</td>
            <td style="border: 1px solid black; width: 82px; text-align: right;font-weight: bolder; font-size: 9px; color:green;">' . number_format(round($order['net']), 2). '</td>
        </tr>        
        <tr>
            <td style="border: 1px solid black; width: 377px; text-align: left; font-size:7px;">
                <span style="text-align: left;font-weight: bolder; font-size: 11px;">' . $client['medical'] . '</span><br><br>
                <span style="text-align: left;  font-size: 8px;">' . $client['address'] . '</span><br><br>
                <span style="text-align: left;font-weight: bolder; font-size: 8px;">Customer Care </span> 
                <span style="text-align: left;font-weight: bolder; font-size: 8px;">: ' . $client['mobile'] . '</span><br>
            </td>
      
             <td style=" width: 152px; text-align: center; font-size: 8px;font-weight: bolder;">
             
             REG. PHARMCIST SIGN <br>
             ' . $order['entry_by'] . ' <br>
                             <img src="../prescriptions/stamp/' . $client['stampFile'] .'"  style="width: 200px; height: 100px;" >

             </td>
        </tr>
        
 
    </table>';

        // Final comments
        $html .= '<br><br><table>
            <tr>
                <td style="width: 100%; font-weight: bold;">Get Well Soon !!!</td>
                
            </tr>
        </table>';
        
        
        }

        // Output the HTML to PDF
        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->Output('invoice.pdf', 'I');
        
        
        
    }
}
      
  }else{
      
      class MYPDF extends TCPDF {
    // Page header
    public function Header() {
        // Leave empty for now or customize it further.
    }

    // Page footer
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'C');
    }
}

// Create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetMargins(10, 20, 10, 10);
$pdf->SetAutoPageBreak(TRUE, 15);
$pdf->AddPage('p');

// Fetch client and order details from database
$client_no = $_GET['id'];
  $order_no = $_GET['order_no'];
$user = htmlspecialchars($_GET['user'], ENT_QUOTES, 'UTF-8');

// Fetch client details
$sql = "SELECT * FROM clients WHERE client_no='$client_no'";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    $client = $result->fetch_assoc();

    // Fetch sales order details
     $sql1 = "SELECT s.*,c.c_cont,c.c_add,c.dc_no,c.gst_no FROM sales s left join customer c ON s.patient_no = c.c_no AND s.client_no = c.client_no   WHERE s.order_no = '". $_GET['order_no']."' ";
    $result1 = $conn->query($sql1);
    if ($result1->num_rows > 0) {
        $order = $result1->fetch_assoc();

        // Start building the HTML content
        $html = '<style>
            
             
        </style>';

        // Header information
   
        
        $html .= '
        
        
        <table style="border: 1px solid black;padding:1px;margin:20px; ">
            <tr>
                <td style=" border-right: 1px solid black;border-left: 1px solid black; border-top: 1px solid black; width: 35%; text-align: left; font-size: 9px;background-color:#D6EAF8;"> <b>' . $client['medical'] . '</b></td>
                <td style=" border-right: 1px solid black;width: 25%; text-align: center; font-size: 9px;"><b>GST TAX INVOICE</b></td>
                <td style="width: 40%; text-align: left; border-top: 1px solid black;font-size: 9px;background-color:#D5F5E3;"> <b>TO,</b></td>
            </tr>
            <tr>
                <td rowspan="3" style=" border-right: 1px solid black;width: 35%; border-left: 1px solid black;text-align: left; font-size: 7px;background-color:#D6EAF8;"> ' . $client['address'] . '</td>
                <td style=" border-right: 1px solid black;width: 25%; text-align: left; font-size: 7px;"> <b>Bill No. : </b>' . $order['billNo'] . '</td>
                <td style="width: 40%; text-align: left; font-size: 8px;background-color:#D5F5E3;"> <b>' . $order['patient_name'] . '</b></td>
            </tr>
            <tr>
                <td style="border-right: 1px solid black; width: 25%; text-align: left; font-size: 7px;"> <b>Bill Date : </b>' . date('d-m-Y', strtotime($order['order_date'])) . '</td>
                <td rowspan="3" style="border-left: 1px solid black;width: 40%; text-align: left; font-size: 7px;background-color:#D5F5E3;"> ' . $order['c_add'] . '</td>
            </tr>
            <tr>
                 <td style="border-right: 1px solid black; width: 25%; text-align: left; font-size: 7px;"> <b>Salesman : </b>' . $order['entry_by'] . '</td>
             </tr>
            <tr>
                <td style="border-right: 1px solid black; width: 35%; border-left: 1px solid black;text-align: left; font-size: 7px;background-color:#D6EAF8;"> <b>Phone : </b>' . $client['mobile'] . '</td>
                <td style="border-right: 1px solid black; width: 25%; text-align: left; font-size: 7px;"> <b>Outstanding : </b>' . $order['net'] . '</td>
             </tr>
            <tr>
                <td style="border-right: 1px solid black; width: 35%;border-left: 1px solid black; text-align: left; font-size: 7px;background-color:#D6EAF8;"> <b>Email : </b>' . $client['email'] . '</td>
                <td style="border-right: 1px solid black; width: 25%; text-align: left; font-size: 7px;"> <b>Time : </b>' . date('h:m:s', strtotime($order['order_date'])) . '</td>
                <td style="width: 40%; text-align: left; font-size: 7px;background-color:#D5F5E3;"> <b>Phone : </b>' . $order['c_cont'] . '</td>
            </tr>
            <tr>
                <td style="border-right: 1px solid black; width: 35%; border-left: 1px solid black;text-align: left; font-size: 7px;background-color:#D6EAF8;"> <b>GSTIN : </b>' . $client['gst_no'] . '</td>
                <td style="border-right: 1px solid black; width: 25%; text-align: left; font-size: 7px;"> </td>
                <td style="width: 40%; text-align: left; font-size: 7px;background-color:#D5F5E3;"> <b>GSTIN : </b>' . $order['gst_no'] . '</td>
            </tr>
            <tr>
                <td style="border-right: 1px solid black; width: 35%; border-left: 1px solid black;text-align: left; font-size: 7px;background-color:#D6EAF8;"><b> DL No. : </b> ' . $client['dl1'] . ',' . $client['dl2'] . ',' . $client['dl3'] . ',' . $client['dl4'] . ' /  <b> FSSAI No. : </b>' . $client['fssaiNo'] . '</td>
                <td style="border-right: 1px solid black; width: 25%; text-align: center; "  > 
                     <img src="https://'.$_SERVER['SERVER_NAME'].'/prescriptions/logo/' . $client['logoFile'] . '" alt="stamp Image" style="width: 80px;height: 20px;">

                </td>
                <td style="width: 40%; text-align: left; font-size: 7px;background-color:#D5F5E3;"> <b>DL No. : </b>' . $order['dc_no'] . '  </td>
            </tr>
        
           
          
         
          
        </table>
         <div></div>';
        
         
        
         $html .= '
    
        
        
        
        <table style="padding:4px;" >
            <tr >
              <th style="border: 1px solid black;width: 105px; font-weight: bold; text-align: left; font-size: 7px;">Product</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">HSN</th>
              <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">B.No</th>
              <th style="border: 1px solid black;width: 35px; font-weight: bold; text-align: center; font-size: 7px;">Exp.</th>
              <th style="border: 1px solid black;width: 30px; font-weight: bold; text-align: center; font-size: 7px;">Qty</th>
               <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;">MRP</th>';
               
               
               
               
               if($order['rateType'] == 'PTR'){
                    
                    $html .= '<th style="border: 1px solid black;width: 68px; font-weight: bold; text-align: center; font-size: 7px;">Rate / PTR </th>';
                      
               }else{
                   
                   
                    $html .= '
                      <th style="border: 1px solid black;width: 34px; font-weight: bold; text-align: center; font-size: 7px;">Rate 
                      ';
                      if($order['rateType'] == 'PTS'){
                           $html .= '/ P.T.S';
                      }
                      if($order['rateType'] == 'PTR'){
                           $html .= '/ P.T.R';
                      }
                      
                      $html .= '</th>';
                      $html .= '
                        
                     <th style="border: 1px solid black;width: 38px; font-weight: bold; text-align: center; font-size: 7px;"> 
                      ';
                     if($order['rateType'] == 'PTS'){
                           $html .= 'P.T.R';
                      }
                      if($order['rateType'] == 'PTR'){
                           $html .= 'P.T.S';
                      }
                      $html .= '</th>';
                      
                      
               }
               
               

              
              
              $html .= '
              <th style="border: 1px solid black;width: 30px; font-weight: bold; text-align: left; font-size: 7px;">Sch.</th>
              <th style="border: 1px solid black;width: 44px; font-weight: bold; text-align: center; font-size: 7px;">Taxable</th>
              <th style="border: 1px solid black;width: 35px; font-weight: bold; text-align: center; font-size: 7px;">Disc</th>
              <th style="border: 1px solid black;width: 30px; font-weight: bold; text-align: center; font-size: 7px;">GST %</th>
              <th style="border: 1px solid black;width: 44px; font-weight: bold; text-align: right; font-size: 7px;">Net</th>
            </tr>
          ';
  

        // Fetch product details
        $sql2 = "SELECT * FROM sale_products WHERE order_no='$order_no'";
        $result2 = $conn->query($sql2);
        
        	$output1 = Array();
        if ($result2->num_rows > 0) {
            while ($row2 = $result2->fetch_assoc()) {
                $exp_date = explode('-', $row2['exp_date']);
                $formatted_exp_date = $exp_date[1] . '/' . substr($exp_date[0], -2);

                $html .= '<tr >
                    <td style="border: 1px solid black; text-align: left; font-size:   7px;">' . substr($row2['m_name'], 0, 3) . ' - ' . $row2['p_name'] . '    ( '.$row2['pack_size'].')</td>
                     <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['hsn'] . '</td>
                     <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['batch_no'] . '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .$formatted_exp_date. '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .$row2['SQty']. '</td>
                     <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['mrp'], 2). '</td>';
                     
                         
                    if($order['rateType'] == 'PTR'){
                        
                    $html .= '  <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['sale_rate'], 2). '</td> ';
                          
                    }else{
                        
                    $html .= '  <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['sale_rate'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .$row2['othRate']. '</td>';
                    
                    }
                         
                          
                    
                     $html .= '
                    <td style="border: 1px solid black; text-align: left; font-size: 7px;">' .$row2['freeQty']. '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['taxable'], 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . number_format($row2['disc_amt'] + $row2['cdDiscAmt'] , 2). '</td>
                    <td style="border: 1px solid black; text-align: center; font-size: 7px;">' .number_format($row2['gst'], 2). '</td>
                    <td style="border: 1px solid black; text-align: right; font-size: 7px;">' . number_format($row2['net'], 2). '</td>
                </tr>';
                
                
                         $taxPer = $row2['gst'];
                        $igst = $row2['igst']  ;
                        $cgst= $row2['cgst']  ;
                        $sgst = $row2['sgst']  ;
                
                        // Check if taxPer already exists in output1
                        $found = false;
                        foreach ($output1 as &$item) {
                            if ($item['taxPer'] == $taxPer) {
                                $item['igst'] += $igst;
                                $item['cgst'] += $cgst;
                                $item['sgst'] += $sgst;
                                $found = true;
                                break;
                            }
                        }
                
                        // If taxPer doesn't exist, add it to output1
                        if (!$found) {
                            $output1[] = array('taxPer' => $taxPer, 'igst' => $igst, 'cgst' => $cgst, 'sgst' => $sgst);
                        }
               
            }
        }
        
         
       $net =   round($order['net']);

         $html .= '
         
            <tr >
               <th style="width: 539px; border: 1px solid black;font-weight: bold; text-align: right; font-size: 7px;"><span style="text-align: right;font-weight: bolder; font-size: 7px; color:green;text-transform: uppercase;">Rs : ' .convertNumberToIndianCurrencyWords($net) . '  Only</span></th>
             </tr>
          </table> 
          <table style="border: 1px solid black;padding:2px;margin:10px; ">
         
        <tr>
            <td style= "width: 377px;border: 1px solid black; text-align: left; font-size:7px;" rowspan="5">
                   
        <table  style="border: 1px solid black;padding:3px;margin:20px; " >
            <tr >
              <th style="border: 1px solid black; width: 25%; font-weight: bold; text-align: left; font-size: 7px;">Tax %</th>
              <th style="border: 1px solid black; width: 25%; font-weight: bold; text-align: left; font-size: 7px;">IGST</th>
              <th style="border: 1px solid black; width: 25%; font-weight: bold; text-align: left; font-size: 7px;">CGST</th>
              <th style="border: 1px solid black; width: 25%; font-weight: bold; text-align: left; font-size: 7px;">SGST</th>
            </tr>
            
                 
    ';
    
$igst = 0;
$cgst = 0;
$sgst = 0;
     
     
            foreach ($output1 as &$item) {
              $html .= '<tr >
                            <td style="border: 1px solid black;  text-align: left; font-size: 7px;">' .number_format($item['taxPer'], 2). '</td>
                            <td style="border: 1px solid black;  text-align: left; font-size: 7px;">' . number_format($item['igst'], 2). '</td>
                            <td style="border: 1px solid black;  text-align: left; font-size: 7px;">' . number_format($item['cgst'], 2). '</td>
                            <td style="border: 1px solid black;  text-align: left; font-size: 7px;">' . number_format($item['sgst'], 2). '</td>
                        </tr>';
                        
                        
                        
                        
                            $igst = $igst + $item['igst'];
                            $cgst = $cgst + $item['cgst'];
                            $sgst = $sgst + $item['sgst'];
                        
                        
            }

        $html .= '
        
            <tr>
                <td style="border: 1px solid black; font-weight: bold; text-align: right; font-size: 7px;">Total</td>
                <td style="border: 1px solid black; font-weight: bold; text-align: left; font-size: 7px;">' . number_format($igst, 2). '</td>
                <td style="border: 1px solid black; font-weight: bold; text-align: left; font-size: 7px;">' . number_format($cgst, 2). '</td>
                <td style="border: 1px solid black; font-weight: bold; text-align: left; font-size: 7px;">' . number_format($sgst, 2). '</td>
            </tr>
        
        
        </table> 
             
             
             
          
            </td>
      
       
            <td style=" width: 79px; text-align: right; font-size: 7px;">Taxable</td>
            <td style=" width: 82px; text-align: right; font-size: 7px;">' . number_format($order['taxable'], 2). '</td>
        </tr>
        <tr >       
            <td style=" width: 79px; text-align: right; font-size: 7px;">DISCOUNT</td>
            <td style=" width: 82px; text-align: right; font-size: 7px;">' . number_format($order['discount'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: right; font-size: 7px;">TAX</td>
            <td style="width: 82px; text-align: right; font-size: 7px;">' . number_format($order['gst'], 2). '</td>
        </tr>
        <tr >       
            <td style="width: 79px; text-align: right; font-size: 7px;"></td>
            <td style="width: 82px; text-align: right; font-size: 7px;"></td>
        </tr>
        
        <tr >       
            <td style="border: 1px solid black; width: 79px; text-align: right;font-weight: bolder; font-size: 9px; ">NET AMT.</td>
            <td style="border: 1px solid black; width: 82px; text-align: right;font-weight: bolder; font-size: 9px; color:green;">' . number_format(round($order['net']), 2). '</td>
        </tr>        
        <tr>
            <td style="border: 1px solid black; width: 377px; text-align: left; font-size:7px;">
              <b style="text-decoration: underline;">Bank Details :  </b> <br><b>Bank Name :  ' . $client['bankName']. ' <br> ACC/NO : ' . $client['accountNo']. '  / IFSC Code : ' . $client['ifscCode']. '</b>
             
            
            </td>
      
             <td style=" width: 152px; text-align: center; font-size: 8px;font-weight: bolder;">
             
             REG. PHARMCIST SIGN <br>';
             
             
             if($_GET['id'] == 'C103' || $_GET['id'] == 'C136'){
                               $html .= ' <span style="color:green;">' . $client['medical'] . '</span>';

             }else{
                              // $html .= ' <span style="color:green;">' . $order['medical'] . '</span>';

             }
              
           
            $html .= '    
             <br>
                             <img src="../prescriptions/stamp/' . $client['stampFile'] .'"  style="width: 150px; height: 80px;" >
             </td>
        </tr>
        
 
    </table>
    
    
           
     
    ';
     
            

        // Output the HTML to PDF
        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->Output('invoice.pdf', 'I');
        
        
        
    }
}
      
  }







            //         <td style="border: 1px solid black; text-align: center; font-size: 7px;">' . $row2['hsn'] . '</td>
            //   <th style="border: 1px solid black;width: 40px; font-weight: bold; text-align: center; font-size: 7px;">HSN</th>




?>
