<?php
// Parameters
$text = isset($_GET['text']) ? $_GET['text'] : "Hello123"; // Text for the barcode
$size = isset($_GET["size"]) ? intval($_GET["size"]) : 60;  // Barcode height
$sizefactor = isset($_GET["sizefactor"]) ? floatval($_GET["sizefactor"]) : 1.2;  // Bar width scale

// Simple Code128 B structure (we will handle alphanumeric input for this example)
function code128($text) {
    $codes = array(
        ' '=>212222, '!'=>222122, '"'=>222221, '#'=>121223, '$'=>121322, '%'=>131222, '&'=>122213,
        "'"=>122312, '('=>132212, ')'=>221213, '*'=>221312, '+'=>231212, ','=>112232, '-'=>122132,
        '.'=>122231, '/'=>113222, '0'=>123122, '1'=>123221, '2'=>223211, '3'=>221132, '4'=>221231,
        '5'=>213212, '6'=>223112, '7'=>312131, '8'=>311222, '9'=>321122, 'A'=>321221, 'B'=>312212,
        'C'=>322112, 'D'=>322211, 'E'=>212123, 'F'=>212321, 'G'=>232121, 'H'=>111323, 'I'=>131123,
        'J'=>131321, 'K'=>112313, 'L'=>132113, 'M'=>132311, 'N'=>211313, 'O'=>231113, 'P'=>231311,
        'Q'=>112133, 'R'=>112331, 'S'=>132131, 'T'=>113123, 'U'=>113321, 'V'=>133121, 'W'=>313121,
        'X'=>211331, 'Y'=>231131, 'Z'=>213113, '['=>213311, '\\'=>213131, ']'=>311123, '^'=>311321,
        '_'=>331121, 'a'=>312113, 'b'=>312311, 'c'=>332111, 'd'=>314111, 'e'=>221411, 'f'=>431111,
        'g'=>111224, 'h'=>111422, 'i'=>121124, 'j'=>121421, 'k'=>141122, 'l'=>141221, 'm'=>112214,
        'n'=>112412, 'o'=>122114, 'p'=>122411, 'q'=>142112, 'r'=>142211, 's'=>241211, 't'=>221114,
        'u'=>413111, 'v'=>241112, 'w'=>134111, 'x'=>111242, 'y'=>121142, 'z'=>121241, '{'=>114212,
        '|'=>124112, '}'=>124211, '~'=>411212
    );

    $code_string = "";  // Store the final barcode pattern
    for ($i = 0; $i < strlen($text); $i++) {
        $char = $text[$i];
        if (isset($codes[$char])) {
            $code_string .= $codes[$char];
        } else {
            // For any character not in the set, use space (as fallback)
            $code_string .= $codes[' '];
        }
    }

    // Add start and stop codes (Code128B specific)
    $start_code = "211214";  // Start B pattern
    $stop_code = "2331112";  // Stop pattern
    
    return $start_code . $code_string . $stop_code;
    
}

// Generate the barcode pattern from the text
$barcode_pattern = code128($text);

// Calculate the total width of the barcode
$code_length = 0;
for ($i = 0; $i < strlen($barcode_pattern); $i++) {
    $code_length += intval($barcode_pattern[$i]);
}

// Create the image dimensions
$img_width = ($code_length * $sizefactor) + 20;  // Add some padding
$img_height = $size + 20;  // Barcode height

// Create the image
$image = imagecreate($img_width, $img_height);
$black = imagecolorallocate($image, 0, 0, 0);
$white = imagecolorallocate($image, 255, 255, 255);
imagefill($image, 0, 0, $white);  // Set background to white

// Draw the barcode on the image
$location = 10;  // Left padding (quiet zone)
for ($position = 0; $position < strlen($barcode_pattern); $position++) {
    $bar_width = intval($barcode_pattern[$position]) * $sizefactor;
    // Alternate between black and white bars
    imagefilledrectangle($image, $location, 0, $location + $bar_width, $size, ($position % 2 == 0 ? $black : $white));
    $location += $bar_width;
}

// Output the image as a PNG
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);
?>
