import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bmr-master-approval',
  templateUrl: './bmr-master-approval.component.html',
  styleUrls: ['./bmr-master-approval.component.css']
})
export class BmrMasterApprovalComponent implements OnInit {

  results;

  isView = false;
  selectedBMR = [];
  isDispensing = false;
  instructions;
  isSifting = false;
  isMilling = false;
  isDrymixing = false;

  dispensingInstructions = [];
  dispensingProcedures = [];

  siftingInstructions = [];
  siftingProcedures = [];

  millingInstructions = [];
  millingProcedures = [];

  dryMixingInstructions = [];
  dryMixingProcedures = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getBMRMasters').subscribe(response => {
      this.results = response;
    });
  }

  viewBMR(index) {
    this.selectedBMR = this.results[index];
    let stages = this.selectedBMR['stage'];
    for (let i = 0; i < stages.length; i++) {
      let data = JSON.parse(stages[i].data);
      if (stages[i].stage == 'DISPENSING') {
        this.dispensingInstructions = data['instructions'];
        this.dispensingProcedures = data['procedures'];
        this.isDispensing = true;
      }
      if (stages[i].stage == 'SIFTING') {
        this.siftingInstructions = data['instructions'];
        this.siftingProcedures = data['procedures'];
        this.isSifting = true;
      }
      if (stages[i].stage == 'MILLING') {
        this.millingInstructions = data['instructions'];
        this.millingProcedures = data['procedures'];
        this.isMilling = true;
      }
      if (stages[i].stage == 'DRY MIXING') {
        this.dryMixingInstructions = data['instructions'];
        this.dryMixingProcedures = data['procedures'];
        this.isDrymixing = true;
      }
    }
    this.isView = true;
  }

  updateBMR(status) {
    this.service.get('production.php?type=updateBMR&status=' + status + '&id=' + this.selectedBMR['id']).subscribe(response => {
      if (response['status'] == "success") {
        this.isView = false;
        this.getBatchPlanningLog();
        alertify.success('Updated Successfully');
        return;
      } else {
        alertify.error('An error occured, please try again');
      }
    });
  }

}
