import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify
@Component({
  selector: 'app-batch-planned',
  templateUrl: './batch-planned.component.html',
  styleUrls: ['./batch-planned.component.css']
})
export class BatchPlannedComponent implements OnInit {

  products;
  results;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getPendingStartBatch').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.isNew = true;

    this.service.get('production.php?type=startBatch&id=' + this.selectedBMR['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Batch Started Successfully');
        this.getBatchPlanningLog();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
