import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CompletedComponent } from './completed/completed.component';
import { DashboardComponent } from './dashboard/dashboard.component';
import { InprocessComponent } from './inprocess/inprocess.component';
import { MasterComponent } from './master/master.component';
import { PlannedComponent } from './planned/planned.component';
import { ProcessLotsComponent } from './process-lots/process-lots.component';
import { YieldComponent } from './yield/yield.component';


const routes: Routes = [
  { path: '', component: DashboardComponent},
  { path: 'master', component: MasterComponent},
  { path: 'process-lots', component: ProcessLotsComponent},
  { path: 'completed', component: CompletedComponent},
  { path: 'planned', component: PlannedComponent},
  { path: 'inprocess', component: InprocessComponent},
  { path: 'yield', component: YieldComponent},
  { path: 'plan', loadChildren: () => import('./plan/plan.module').then(m=>m.PlanModule)},
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class BmrRoutingModule { }
