import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-completed',
  templateUrl: './completed.component.html',
  styleUrls: ['./completed.component.css']
})
export class CompletedComponent implements OnInit {

  isView = false;
  results;

  selectedIndex = -1;
  selectedBMR = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getCompletedBatches();
  }

  getCompletedBatches() {
    this.service.get('bmr.php?type=getCompletedBatches').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    this.isView = true;
  }

  downloadPDF() {
    let url = this.service.url + '/pdf1/bmr.php?bmr_no=' + this.selectedIndex;
    window.open(url, '_blank');
  }

}
