import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  results;

  dosages;
  products;
  selectedProduct = [];
  mfrs;
  lots = [];

  product_code = '';
  lot = 0;
  batch_qty = 0;
  remaining_qty = 0;

  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit() {
    this.getDosages();
  }

  getDosages() {
    this.service.get('production/batch.php?type=getDosages').subscribe(response => {
      this.dosages = response;
    });
  }

  getProducts(index) {
    index = index - 1;
    this.products = this.dosages[index].products;
  }

  viewBatch(index) {}

  getMFRs(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.lots = this.products[index].lots;
  }

  selectedLot() {
    let batch_qty = this.batch_qty;
    for (let i = 0; i < this.lots.length; i++) {
      let result = this.lots[i];
      if (batch_qty <= +result["yield_qty"]) {
        result['status1'] = "selected";
        result['selected_qty'] = batch_qty;
        result['remaining_qty'] = +result["yield_qty"] - batch_qty;
        batch_qty = 0;
      } else if (batch_qty > +result["yield_qty"]) {
        result['status1'] = "selected";
        result['selected_qty'] = +result["yield_qty"];
        result['remaining_qty'] = 0;
        batch_qty = batch_qty - +result["yield_qty"];
      } else if (batch_qty == 0) {
        result['status1'] = "not selected";
        result['selected_qty'] = 0;
        result['remaining_qty'] = +result["yield_qty"];
      }
    }
    this.remaining_qty = batch_qty;
  }

 
  saveBatch(data) {
    if (!data.valid) {
      alertify.error('All fields are required!');
      return;
    }
    let temp = data.value;
    //temp['yield_qty'] = this.batch_qty;
    temp['lots'] = this.lots;
    this.service.post('production/batch.php?type=saveBatch', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Batch saved successfully!');
        this.batch_qty = 0;
        this.router.navigate(['/bmr']);
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
