import { DataAccessService } from 'src/app/data-access.service';
import { Component, OnInit, ViewChild } from '@angular/core';
declare let alertify;
@Component({
  selector: 'app-interviewform',
  templateUrl: './interviewform.component.html',
  styleUrls: ['./interviewform.component.css']
})
export class InterviewformComponent implements OnInit {
  candidates;
  qualification;
  place;
  email_id;
  mobile_no;
  interview_date;
  interview_time;
  venue;
  contact_person;
  companies = [];
  index = 0;
  form_no;
  data = [];

  entries;
  isViewForm = false;
  isNewForm = false;
  selectedForm = [];
  constructor(private service: DataAccessService) {
   }

  ngOnInit() {
    this.getCandidates();
    this.getPreviousInterviews();
  }
  
  showForm(index) {
    this.selectedForm = this.entries[index];
    this.isViewForm = true;
  }

  getPreviousInterviews() {
    this.service.get('hrDepartment.php?type=getpreviousInterviews').subscribe(response => {
      this.entries = response;
    });
  }

  getCandidates() {
    this.service.get('hrDepartment.php?type=getScheduledCandidates')
    .subscribe(response => {
      this.candidates = response;
    });
  }

  saveForm(interviewform) {
    if (!interviewform.valid) {
      alertify.error('All fields are required');
      return;
    }
    this.data = interviewform.value;
    this.data['experience_company'] = this.companies;
    this.service.post('hrDepartment.php?type=interviewform', JSON.stringify(this.data))
    .subscribe(response => {
      if(response['status'] === 'success') {
        alertify.success('Interview has been completed');
        interviewform.reset();
        this.getCandidates();
        this.isNewForm = false;
      } else {
        alertify.error('An error occured');
      }
      },
    (error: Response) => {
      if (error.status === 400) {
        alertify.error('An error has occurred.');
      } else {
        alertify.error('An error has occurred, http status:' + error.status);
      }
    });
  }

  getCandidateInfo(value) {
    const index = value - 1;
    this.form_no = this.candidates[index].id;
    this.qualification = this.candidates[index].qualification;
    this.place = this.candidates[index].place;
    this.email_id = this.candidates[index].email_id;
    this.mobile_no = this.candidates[index].mobile_no;
    this.interview_date = this.candidates[index].interview_date;
    this.interview_time = this.candidates[index].interview_time;
    this.venue = this.candidates[index].venue;
    this.contact_person = this.candidates[index].contact_person;
  }

  addexperience(company, experience) {
    let data = "{\"company\":\"" + company + "\", \"experience\":\"" + experience + "\"}";
    this.companies[this.index] = JSON.parse(data);
    this.index++;

  }
}
