import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  dosages;
  products;

  selectedDosage = [];
  isTablet = true;
  selectedProduct = [];
  mfrs;
  isProd = false;
  selectedBatch = [];
  isBatch = false;

  batch_size = 0;
  lots = 0;

  stages;
  packing;

  materials = [];
  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit() {
    this.getDosages();
  }

  getDosages() {
    this.service.get('production/batchformula.php?type=getDosages').subscribe(response => {
      this.dosages = response;
    });
  }

  // getStages(value) {
  //   if (this.selectedDosage['dosage_form'] !== 'TABLET') {
  //     value = 'Direct Compression';
  //   }
  //   this.service.get('production/bmr.php?type=getStages&granulation_type=' + value + '&dosage_form=' + this.selectedDosage['dosage_form']).subscribe(response => {
  //     this.stages = response;
  //   });
  // }

  // getPacking(value) {
  //   this.service.get('production/bmr.php?type=getStages&packing=' + value).subscribe(response => {
  //     this.packing = response;
  //   });
  // }

  getProducts(index) {
    index = index - 1;
    if (index !== -1) {
      this.selectedDosage = this.dosages[index];
      this.products = this.selectedDosage['products'];

      if (this.selectedDosage['dosage_form'] == 'TABLET') {
        this.isTablet = true;
      } else {
        this.isTablet = false;
       // this.getStages('Direct Compression');
      }
    }
  }

  getProductDetails(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.mfrs = this.selectedProduct['mfrs'];
    this.isProd = true;
  }

  showBatch(index) {
    index = index - 1;
    let batches = this.selectedProduct['mfrs'];
    this.selectedBatch = batches[index];
    let temp = this.selectedBatch['materials'];

    let batch_size = this.selectedBatch['batch_size'];

    if (batch_size !== "1") {
      let materials = temp;

      for (let i = 0; i < materials.length; i++) {
        let material = materials[i];

        material['qty'] = +material['qty'] / +batch_size;
        materials[i] = material;
      }
      this.materials = materials;
    } else {
      this.materials = temp;
    }

    this.isBatch = true;
    this.updateBatchQty();
  }

  updateBatchQty() {
    let materials = this.materials;
    for (let i = 0; i < materials.length; i++) {
      let material = materials[i];
      if (material['unit'] == "mg") {
        material["batch_qty"] = (material["qty"] * (this.batch_size / 1000000)).toFixed(2);
        material['batch_unit'] = "Kg";
      } else if (material['unit'] == "Gram") {
        material["batch_qty"] = (material["qty"] * (this.batch_size / 1000)).toFixed(2);
        material['batch_unit'] = "Kg";
      } else {
        material["batch_qty"] = (material["qty"] * this.batch_size).toFixed(2);
        material['batch_unit'] = material['unit'];
      }
      materials[i] = material;
    }
    this.materials = materials;
  }

  saveBatch(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['materials'] = this.selectedBatch['materials'];
   // temp['stages'] = this.stages;
   // temp['packing'] = this.packing;
    this.service.post('production/batchformula.php?type=saveBatchFormula', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        //this.stages = [];
        //this.packing = [];
        data.resetForm();
        alertify.success('Data Saved Successfully!');
        this.router.navigate(['/ebmr/batchformula']);
      } else {
        alertify.error('An error occured, Please try again!');
      }
    });
  }

}
