import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;

@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  products;


  instructionList = [];
  constructor(private service: DataAccessService,private router:Router) { }

  ngOnInit(): void {
    this.getProducts();
  }

  getProducts(){
    this.service.get('production/instruction.php?type=getProducts').subscribe(response => {
      this.products = response;
    });
  }

  add(data){
    if(!data.valid){
      alertify.error('All fields are required!');
      return;
    }
    let temp = data.value;
    this.instructionList[Object.keys(this.instructionList).length] = temp;
    data.resetForm();
  }


  save(data){
    if(!data.valid){
      alertify.error('All fields are requried!');
      return;
    }
    let temp = data.value;
    temp['instructions'] = this.instructionList;
    this.service.post('production/instruction.php?type=saveInstruction',JSON.stringify(temp)).subscribe(response=> {
      if(response['status'] == 'success'){
        alertify.success("Instruction Saved Successfully!");
        this.router.navigate(['/ebmr/instruction']);
        data.reset();
      } else{
        alertify.error("Failed an error occured,Please try again!");
      }
    });

  }

}
