import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-log',
  templateUrl: './log.component.html',
  styleUrls: ['./log.component.css']
})
export class LogComponent implements OnInit {

  isView = false;
  results;

  selectedResult = [];
  specification = [];
  specification1 = [];
  constructor(private service: DataAccessService) { }

  ngOnInit(): void {
    this.getMFRs();
  }

  getMFRs() {
    this.service.get('production/master.php?type=getMFRs').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedResult = this.results[index];
    this.specification = this.selectedResult['specification'];
    this.specification1 = this.selectedResult['specification1'];
    this.isView = true;
  }

  close() {
    this.isView = false;
  }

  download() {
    this.service.open('production/master.php?type=downloadMFR&id=' + this.selectedResult['id']);
    this.isView = false;
  }

}
