import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-check-shortages',
  templateUrl: './check-shortages.component.html',
  styleUrls: ['./check-shortages.component.css']
})
export class CheckShortagesComponent implements OnInit {

  results;
  isNewBP = false;
  isView = false;

  dosages;
  batches;
  dosage_form = '';
  product_name = '';
  product_code = '';
  grade = '';
  grades;
  products;
  bom_no;
  materials;
  isnote = false;
  shortMaterial = [];

  bombtn = false;
  isBOM = false;
  bom = {};
  isShowAPI = false;
  selectedMaterial = [];

  selectedBatch = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getDosageForms();
  }

  getDosageForms() {
    this.service.get('qaDepartment.php?type=getDosageForms').subscribe(response => {
      this.dosages = response;
    });
  }

  getProducts() {
    this.service.get('production.php?type=getDosageformByProduct&dosage_form=' + this.dosage_form).subscribe(response => {
      this.products = response;
    });
  }

  getProductGrades() {
    this.service.get('production.php?type=getProductGrades&dosage_form=' + this.dosage_form + '&product_name=' + this.product_name).subscribe(response => {
      this.grades = response;
    });
  }

  getBatchSizes(index) {
    index = index - 1;
    this.product_code = this.grades[index].product_code;
    this.service.get('production.php?type=getBatchSizes&product_code=' + this.product_code).subscribe(response => {
      this.batches = response;
    });
  }

  getBOM() {
    this.service.get('production.php?type=getbombyno&bom_no=' + this.bom_no).subscribe(response => {
      this.bombtn = true;
      this.bom = response;
      this.materials = response['materials'];

      for (let i = 0; i < this.materials.length; i++) {
        if (this.materials[i].isShortage == 'yes') {
          this.isnote = true;
          this.shortMaterial = this.materials[i];
        }
      }
    });
  }

  showAPICalc(index) {
    this.selectedMaterial = this.materials[index];
    console.log(this.selectedMaterial['materials']);
    this.isShowAPI = true;
  }

  saveBatchPlanning() {
    if (this.dosage_form == '' || this.product_code == '' || this.bom_no == '' || this.materials.length == 0) {
      alertify.error('All fields are required');
      return;
    }
    let temp = {};
    temp['dosage_form'] = this.dosage_form;
    temp['product_code'] = this.product_code;
    temp['bom_no'] = this.bom_no;
    temp['materials'] = this.materials;
    this.service.post('production.php?type=saveBatchPlanning', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('saved successfully');
        this.isNewBP = false;
        this.product_name = '';
        this.product_code = '';
        this.dosage_form = '';
        this.grade = '';
      } else {
        alertify.error('error');
      }
    });
  }

  addIndend(index, indend) {
    if (indend == 'no') {
      this.materials[index].indend = 'yes';
    } else if (indend == 'yes') {
      this.materials[index].indend = 'no';
    }
  }

  viewBatch(index) {
    this.selectedBatch = this.results[index];
    this.isView = true;
  }

}
