import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-start-batch',
  templateUrl: './start-batch.component.html',
  styleUrls: ['./start-batch.component.css']
})
export class StartBatchComponent implements OnInit {

  isViewBP = false;
  entries;
  selectedBP = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getApprovedBatchPlannings();
  }

  getApprovedBatchPlannings() {
    this.service.get('production.php?type=getApprovedBatchPlannings').subscribe(response => {
      this.entries = response;
    });
  }

  viewBP(index) {
    this.selectedBP = this.entries[index];
    this.isViewBP = true;
  }

  startBatch(index) {
    let lots = this.selectedBP['lots'];
    lots[index].status = 'inprocess';

    this.service.post('production.php?type=startBatch&bp_no=' + this.selectedBP['no'], JSON.stringify(lots)).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('updated successfully');
      } else {
        alertify.error('An error occured');
      }
    });
  }

}
