import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-inprocess-specification',
  templateUrl: './inprocess-specification.component.html',
  styleUrls: ['./inprocess-specification.component.css']
})
export class InprocessSpecificationComponent implements OnInit {

  isView = false;
  specifications;

  selectedSpec= [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getInprocessSpecification();
  }

  getInprocessSpecification() {
    this.service.get('qa.php?type=getInprocessSpecification').subscribe(response => {
      this.specifications = response;
    });
  }

  viewSpecification(index) {
    this.selectedSpec = this.specifications[index];
    this.isView = true;
  }

}
