import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-awaiting',
  templateUrl: './awaiting.component.html',
  styleUrls: ['./awaiting.component.css']
})
export class AwaitingComponent implements OnInit {

  results;
  isNew = false;

  selectedResult = []; 
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getReadyBatchPlans();
  }

  getReadyBatchPlans(){
    this.service.get('production/product.php?type=getReadyBatchPlans').subscribe(response => {
      this.results = response;
    });
  }  

  view(index) {
    this.selectedResult = this.results[index];
    this.isNew = true;
  }

  startBatch() {
    this.service.get('production/product.php?type=startBatch&id=' + this.selectedResult['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Start Production Successfully');
        this.isNew = false;
        this.getReadyBatchPlans();
      } else {
        alertify.error(response['status']);
      }
    });
  }

}
