import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-receiving',
  templateUrl: './receiving.component.html',
  styleUrls: ['./receiving.component.css']
})
export class ReceivingComponent implements OnInit {
  results;
  isView=false;
  selectedResult=[];

  constructor(private service:DataAccessService) { }

  ngOnInit() {
    this.getDispensingReceiving();
  }
  
  getDispensingReceiving(){
    this.service.get('production/dispensing.php?type=getDispensingReceiving').subscribe(response=>{
      this.results=response;
    });
  }

  view(index){
    this.selectedResult=this.results[index];
    this.isView=true;
  }

  receiveDispensingMaterials(status){
    this.service.get('production/dispensing.php?type=receiveDispensingMaterials&status='+status +'&id=' +this.selectedResult['id']).subscribe(response=>{
      if(response['status']=='success'){
        alertify.success('Dispensing material is Successful received');
        this.isView = false;
        this.getDispensingReceiving();
      }else{
        alertify.error('some error occured!');
      }
    });
  }

}
