import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-lmr-master',
  templateUrl: './lmr-master.component.html',
  styleUrls: ['./lmr-master.component.css']
})
export class LmrMasterComponent implements OnInit {
  /* isNew = false;
  isView = false;
  isInprocess = false;
  results;
  dosages;

  products;
  selectedProduct = [];
  selectedBatch = [];
  isProd = false;
  isBatch = false;

  selectedBMR = [];
  processes;
  stages;

  selectedStages = [];
  stage = ''; */

  data;
  isView = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getLotMaster();
    /* this.getLotPlanningLog(); */
  }

  getLotMaster() {
    this.service.get('bmr.php?type=getLotMaster').subscribe(response => {
      this.data = response;
      this.isView = true;
    });
  }

  /* getLotPlanningLog() {
    this.service.get('bmr.php?type=getLMRLog').subscribe(response => {
      this.results = response;
    });
  }

  newBMR() {
    this.getDosages();
    this.isNew = true;
  }

  getDosages() {
    this.service.get('qaDepartment.php?type=getDosageForms').subscribe(response => {
      this.dosages = response;
    });
  }

  getProductsByDosage(value) {
    if (value == '') {
      this.products = [];
      return;
    }
    this.service.get('bmr.php?type=getProductsByDosage&dosage_form=' + value).subscribe(response => {
      this.products = response;
    });
  }

  getProductDetails(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.isProd = true;
  }

  showBatch(index) {
    index = index - 1;
    let batches = this.selectedProduct['lots'];
    this.selectedBatch = batches[index];
    this.isBatch = true;
  }

  saveInitBMR(data) {
    if (!data.valid) {
      alert('All fields are required');
      return;
    }
    let temp = data.value;
    temp['lom_no'] = this.selectedBatch['id'];
    temp['mf_no'] = this.selectedBatch['mf_no'];
    this.service.post('bmr.php?type=saveInitLMR', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        this.getLotPlanningLog();
        this.isNew = false;
        alert('Saved Successfully');
      } else {
        alert('An error occured, Please try again');
      }
    });
  }

  viewBMR(index) {
    this.isInprocess = false;
    this.isView = false;

    this.selectedBMR = this.results[index];
    if (this.selectedBMR['stages'] == 'pending') {
      this.selectedStages[this.selectedStages.length] = 'DISPENSING';
      this.getProcesses();
    }
    if (this.selectedBMR['stages'] == 'done') {
      let stages = this.selectedBMR['stage'];
      for (let i = 0; i < stages.length; i++) {
        let stage = stages[i];
        stages[i] = stage;
      }
      this.selectedBMR['stage'] = stages;
    }
    if (this.selectedBMR['status'] == 'inprocess') {
      this.isInprocess = true;
    } else if (this.selectedBMR['status'] == 'approve' || this.selectedBMR['status'] == 'active') {
      this.isView = true;
    }
  }

  getProcesses() {
    this.service.get('bmr.php?type=getLotProcesses&dosage_form=' + this.selectedBMR['dosage_form']).subscribe(response => {
      this.processes = JSON.parse(JSON.stringify(response));
      this.processes.forEach(element => {
        element.checked = false;
      });
    });
  }

  addStage() {
    this.selectedStages[this.selectedStages.length] = this.stage;
    this.stage = '';
  }

  onSave(stageForm) {
    console.log(stageForm.value);
  }

  getBMRStages() {
    this.service.get('production.php?type=getBMRStages&bmr_no=' + this.selectedBMR['id']).subscribe(response => {
      this.stages = response;
    });
  }

  saveStages() {
    if (this.selectedStages.length == 1) {
      alert('Please add stages in Table');
      return;
    }
    const url = 'bmr.php?type=saveLMRStages&bmr_no=' + this.selectedBMR['id'] + '&dosage_form=' + this.selectedBMR['dosage_form'];
    this.service.post(url, JSON.stringify(this.selectedStages)).subscribe(response => {
      if (response['status'] === 'success') {
        alert('Saved Successfully');
        this.getLotPlanningLog();
        this.isInprocess = false;
      } else {
        alert('An error occured, Please try again');
      }
    });
  }

  addProcedure(value, index) {
    let stages = this.selectedBMR['stage'];
    let stage = stages[index];
    let data = stage['data'];
    data[data.length] = value;
    stage['data'] = data;
    stages[index] = stage;
    this.selectedBMR['stage'] = stages;
  }

  deleteProcedure(p, index) {
    let stages = this.selectedBMR['stage'];
    let stage = stages[index];
    let data = stage['data'];
    data.splice(p, 1);
    stage['data'] = data;
    stages[index] = stage;
    this.selectedBMR['stage'] = stages;
  }

  saveProcedure(stage, data, id) {
    this.service.post('bmr.php?type=saveProcedure&stage=' + stage + '&id=' + id, JSON.stringify(data)).subscribe(response => {
      if (response['status'] == 'success') {
        alert('Procedure saved Successfully');
        this.getLotPlanningLog();
        this.isInprocess = false;
      } else {
        alert('An error occured, please try again!');
      }
    });
  }

  updateLMRMaster(action) {
    this.service.get('bmr.php?type=updateLMRMaster&action=' + action + '&id=' + this.selectedBMR['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alert('LMR Master updated successfully');
        this.getLotPlanningLog();
        this.isInprocess = false;
      } else {
        alert('An error occured, please try again!');
      }
    });
  } */

}
