import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

import { DashboardComponent } from './dashboard/dashboard.component';
import { LmrMasterComponent } from './lmr-master/lmr-master.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { ClarityModule } from '@clr/angular';
import { ShortageCalculationComponent } from './shortage-calculation/shortage-calculation.component';
import { LotPlanningComponent } from './lot-planning/lot-planning.component';
import { LotFormulaComponent } from './lot-formula/lot-formula.component';
import { LotProcessingComponent } from './lot-processing/lot-processing.component';
import { PlannedLotsComponent } from './planned-lots/planned-lots.component';
import { InprocessLotsComponent } from './inprocess-lots/inprocess-lots.component';
import { CompletedLotsComponent } from './completed-lots/completed-lots.component';
import { ProductionReportComponent } from './production-report/production-report.component';
import { NewLotPlanComponent } from './new-lot-plan/new-lot-plan.component';
import { LotPlanningApprovalComponent } from './lot-planning-approval/lot-planning-approval.component';
import { YieldComponent } from './yield/yield.component';
import { RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {path: '', component: DashboardComponent},
  {path: 'lmr-master', component: LmrMasterComponent},
  {path: 'shortage-calculation', component: ShortageCalculationComponent},
  {path: 'lot-planning', component: LotPlanningComponent},
  {path: 'new-lot-plan', component: NewLotPlanComponent},
  {path: 'lot-formula', component: LotFormulaComponent},
  {path: 'lot-processing', component: LotProcessingComponent},
  {path: 'planned-lots', component: PlannedLotsComponent},
  {path: 'inprocess-lots', component: InprocessLotsComponent},
  {path: 'completed-lots', component: CompletedLotsComponent},
  {path: 'production-report', component: ProductionReportComponent},
  {path: 'lot-plan-approval', component: LotPlanningApprovalComponent},
  {path: 'yield', component: YieldComponent},
  { path: 'plan', loadChildren: () => import('./plan/plan.module').then(m=>m.PlanModule), data: {preload: false}},
  { path: 'batch', loadChildren: () => import('./batch/batch.module').then(m=>m.BatchModule), data: {preload: false}},
];

@NgModule({
  declarations: [DashboardComponent, LmrMasterComponent, ShortageCalculationComponent, LotPlanningComponent, LotFormulaComponent, LotProcessingComponent, PlannedLotsComponent, InprocessLotsComponent, CompletedLotsComponent, ProductionReportComponent, NewLotPlanComponent, LotPlanningApprovalComponent, YieldComponent],
  imports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    HttpClientModule,
    ClarityModule,
    RouterModule.forChild(routes)
  ]
})
export class LmrModule { }
