import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-lot-formula',
  templateUrl: './lot-formula.component.html',
  styleUrls: ['./lot-formula.component.css']
})
export class LotFormulaComponent implements OnInit {
  isViewBOM = false;
  isNewBOM = false;
  users;
  products;
  grades;
  mfr;
  materials;

  selectedProd = [];
  isViewProd = false;

  counter = Array;
  lot_size = 0;

  process = '';
  equipment_name = '';
  equipments;
  selectedEquipments = [];
  selectedMFR = [];

  processes;

  boms;
  selectedBOM;

  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBOMs();
    this.getProducts();
  }

  getBOMs() {
    this.service.get('bmr.php?type=getLotFormulas').subscribe(response => {
      this.boms = response;
    });
  }

  getProducts() {
    this.service.get('qaDepartment.php?type=getApprovedProducts')
    .subscribe(response => {
      this.products = response;
    });
  }

  getGrades() {
    this.service.get('').subscribe(response => {
      this.grades = response;
    });
  }

  getProductDetails(index) {
    index = index - 1;
    this.selectedProd = this.products[index];
    this.isViewProd = true;
    this.getProcesses();
    this.getProductMFR(this.selectedProd['product_code']);
  }

  getProcesses() {
    this.service.get('rndDepartment.php?type=getManufacturingProccesses&dosage_form=' + this.selectedProd['dosage_form']).subscribe(response => {
      this.processes = response;
    });
  }

  getProductMFR(value) {
    this.service.get('rndDepartment.php?type=getProductMFR&product_code=' + value).subscribe(response => {
      this.mfr = response;
      /* this.mf_no = this.mfr[0].mfr_no;
      this.materials = this.mfr[0].materials; */
    });
  }

  showMaterials(index) {
    index = index - 1;
    this.selectedMFR = this.mfr[index];
    this.updateMaterial();
  }

  updateMaterial() {
    for (let i = 0; i < this.selectedMFR['materials'].length; i++) {
      let unit_qty = this.selectedMFR['materials'][i].qty;
      let standard_qty = unit_qty * this.lot_size;
      let std_qty = unit_qty * this.lot_size;
      let qty = '', qty1 = '';
      if (this.selectedMFR['materials'][i].unit == 'mg') {
        qty = (std_qty / 1000000).toFixed(2);
        qty1 = (standard_qty / 1000000).toFixed(2);
      }
      this.selectedMFR['materials'][i].lot_qty = (+qty).toFixed(2);
    }

    let data = this.selectedMFR['materials'];
    for (let j = 0; j < this.processes.length; j++) {
      let temp1 = this.processes[j];
      let test = [];
      for (let i = 0; i < data.length; i++) {
        let temp = data[i];
        if (temp['process'] == temp1['step']) {
          test[test.length] = data[j];
        }
      }
      this.selectedMFR[temp1['step']] = test;
    }
  }

  saveBOM(data) {
    let temp = data.value;

    this.service.post('bmr.php?type=saveLotFormula', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] === 'success') {
        this.getBOMs();
        this.isNewBOM = false;
        data.resetForm();
      } else {
        alertify.error('error');
      }
    });
  }

  viewBOM(index) {
    this.isViewBOM = true;
    this.selectedBOM = this.boms[index];
  }

}
