import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-lot-planning',
  templateUrl: './lot-planning.component.html',
  styleUrls: ['./lot-planning.component.css']
})
export class LotPlanningComponent implements OnInit {
  results;
  isNewBP = false;
  isView = false;

  selectedBatch;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('bmr.php?type=getLotPlanningLog').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBatch = this.results[index];
    this.isView = true;
  }

}
