import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new-lot-plan',
  templateUrl: './new-lot-plan.component.html',
  styleUrls: ['./new-lot-plan.component.css']
})
export class NewLotPlanComponent implements OnInit {

  dosages;
  batches;
  dosage_form = '';
  product_name = '';
  product_code = '';
  grade = '';
  grades;
  products;
  bom_no;

  bombtn = false;
  isBOM = false;
  bom = {};
  isShowAPI = false;
  selectedMaterial = [];

  selectedBMR = [];

  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit() {
    this.getDosageForms();
  }

  getDosageForms() {
    this.service.get('qaDepartment.php?type=getDosageForms').subscribe(response => {
      this.dosages = response;
    });
  }

  getProducts() {
    this.service.get('production.php?type=getDosageformByProduct&dosage_form=' + this.dosage_form).subscribe(response => {
      this.products = response;
    });
  }

  getProductGrades() {
    this.service.get('production.php?type=getProductGrades&dosage_form=' + this.dosage_form + '&product_name=' + this.product_name).subscribe(response => {
      this.grades = response;
    });
  }

  getBatchSizes(index) {
    index = index - 1;
    this.product_code = this.grades[index].product_code;
    this.service.get('bmr.php?type=getLotSizesByProduct&product_code=' + this.product_code).subscribe(response => {
      this.batches = response;
    });
  }

  getBOM(index) {
    index = index - 1;
    this.selectedBMR = this.batches[index];
  }

  showAPICalc(index) {
    let materials = this.selectedBMR['mfr_materials'];
    this.selectedMaterial = materials[index];
    this.isShowAPI = true;
  }

  saveBatchPlanning(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['dosage_form'] = this.dosage_form;
    temp['product_code'] = this.product_code;
    temp['materials'] = this.selectedBMR['mfr_materials'];
    temp['mfr_no'] = this.selectedBMR['mfr_no'];
    temp['unit'] = this.selectedBMR['unit'];
    this.service.post('bmr.php?type=saveLotPlanning', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('saved successfully');
        this.router.navigate(['/lmr']);
      } else {
        alertify.error('error');
      }
    });
  }

}
