import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-planned-lots',
  templateUrl: './planned-lots.component.html',
  styleUrls: ['./planned-lots.component.css']
})
export class PlannedLotsComponent implements OnInit {

  products;
  results;
  selectedIndex = -1;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPlannedLots();
  }

  getPlannedLots() {
    this.service.get('bmr.php?type=getPlannedLots').subscribe(response => {
      this.results = response;

      /* for (let i = 0; i < this.results.length; i++) {
        let selectedBMR = this.results[i];
        let stages = selectedBMR['stages'];
        for (let i = 0; i < stages.length; i++) {
          let stage = stages[i];
          stage['instructions'] = JSON.parse(stage['instructions']);
          stages[i] = stage;
        }
        selectedBMR['stages'] = stages;
        this.results[i] = selectedBMR;
      } */
    });
  }

  viewBatch(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    this.isNew = true;
  }

  startLot() {
    let results = this.results;
    this.selectedBMR['start_by'] = localStorage.getItem('emp_id');
    this.selectedBMR['start_date'] = new Date().toLocaleDateString('en-CA');
    this.selectedBMR['current_stage'] = 'DISPENSING';
    this.selectedBMR['status'] = 'inprocess';
    results[this.selectedIndex] = this.selectedBMR;
    this.service.post('bmr.php?type=startLot', JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Lot Started Successfully');
        this.isNew = false;
        this.getPlannedLots();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
