import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-master-formula',
  templateUrl: './master-formula.component.html',
  styleUrls: ['./master-formula.component.css']
})
export class MasterFormulaComponent implements OnInit {
  isView = false;
  isNew = false;

  reports;
  equipments;
  selectedReport = [];

  isInprocess = false;
  clients;
  materials;
  products;

  equipmentList = [];
  isLL = false;

  selectedProduct = [];
  isShowProduct = false;

  selectedMaterial = [];
  materialList = [];
  total_qty = 0;

  selectedStages = [
    { "id": 1, "stage": "DISPENSING" }
  ];
  constructor(private service: DataAccessService, private router: Router, private fb: FormBuilder) {
  }

  ngOnInit() {
    this.getMasterFormulaReports();
  }

  getMasterFormulaReports() {
    this.service.get('production/lot.php?type=getMasterFormulaReports').subscribe(response => {
      this.reports = response;
    });
  }

  view(index) {
    this.selectedReport = this.reports[index];
    this.isView = true;
  }

  new() {
    this.getProducts();
    this.getAllMaterials();
    this.getClients();
    this.getEquipments();
    this.isNew = true;
  }

  getProducts() {
    this.service.get('production/lot.php?type=getProducts')
    .subscribe(response => {
      this.products = response;
    });
  }

  getAllMaterials() {
    this.service.get('production/lot.php?type=getMaterials').subscribe(response => {
      this.materials = response;
    });
  }

  getClients() {
    this.service.get('production/lot.php?type=getClients').subscribe(response => {
      this.clients = response;
    });
  }

  getEquipments(){
    this.service.get('equipments.php?type=getEquipments').subscribe(response => {
      this.equipments = response;
    });
  }

  getProdDetails(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.isShowProduct = true;
  }

  selectMaterial(index) {
    index = index - 1;
    this.selectedMaterial = this.materials[index];
  }

  addRawMaterial(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    this.selectedMaterial['qty'] = temp['qty'];
    this.selectedMaterial['unit'] = temp['unit'];
    this.selectedMaterial['overages'] = temp['overages'];
    this.selectedMaterial['role'] = temp['role'];

    let qty = (+temp['qty'] * +temp["overages"] / 100).toFixed(2);
    this.selectedMaterial['total_qty'] = +temp['qty'] + +qty;
    if (temp['unit'] == 'Mg' || temp['unit'] == 'Gram' || temp['unit'] == 'Kg') {
      if (temp['unit'] == 'Mg') {
        let value = +temp['qty'] / 1000000;
        this.total_qty += +value;
      } else if (temp['unit'] == 'Gram') {
        let value = +temp['qty'] / 1000;
        this.total_qty += +value;
      } else if (temp['unit'] == 'Kg') {
        let value = +temp['qty'];
        this.total_qty += +value;
      }
    }
    this.materialList[this.materialList.length] = this.selectedMaterial;
    this.total_qty = +(this.total_qty.toFixed(5));
    this.selectedMaterial = [];
    data.resetForm();
    let material_code = document.getElementById('material_code') as HTMLElement;
    material_code.focus();
  }

  addStage(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['id'] = this.selectedStages.length;
    this.selectedStages[this.selectedStages.length] = temp;
    data.resetForm();
    let stage = document.getElementById('stage') as HTMLElement;
    stage.focus();
  }

  addEquipments(data){
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
     let temp = data.value;
     this.equipmentList[Object.keys(this.equipmentList).length] = temp;
     data.resetForm;
  }

  checkLL(nameLL){
    if (nameLL === "Client Manufacturing") {
      this.isLL = true;
    } else if (nameLL === "Owner"){
      this.isLL = false;
    }
  }

  saveMasterFormula(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    let diff = this.total_qty * 0.1 / 100;
    let min = this.total_qty - diff;
    let max = this.total_qty + diff;
    if (+temp['batch_size'] <= +min || +max <= +temp['batch_size']) {
      alertify.error('Batch Size and Materials total Qty not match');
      return;
    }
    temp['materials'] = this.materialList;
    temp['stages'] = this.selectedStages;
    temp['equipments'] = this.equipmentList;
    this.service.post('production/lot.php?type=saveMasterFormula', JSON.stringify(temp))
    .subscribe(response => {
      if (response['status'] === 'success') {
        this.isNew = false;
        alertify.success('Data Saved Successfully');
        this.getMasterFormulaReports();
      } else {
        alertify.error('An error has occurred, Please try again');
      }
      },
    (error: Response) => {
      if (error.status === 400) {
        alertify.error('An error has occurred.');
      } else {
        alertify.error('An error has occurred, http status:' + error.status);
      }
    });
  }

}
