import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-mfr-approval',
  templateUrl: './mfr-approval.component.html',
  styleUrls: ['./mfr-approval.component.css']
})
export class MfrApprovalComponent implements OnInit {

  isView = false;
  selectedReport = [];
  reports;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getMasterFormulaReports();
  }

  getMasterFormulaReports() {
    this.service.get('production/lot.php?type=getMasterFormulaReports').subscribe(response => {
      this.reports = response;
    });
  }

  view(index) {
    this.selectedReport = this.reports[index];
    this.isView = true;
  }

  updateMFR(value) {
    this.service.get('production/lot.php?type=updateCheckingMFR&status=' + value + '&id=' + this.selectedReport['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Updated Successfully');
        this.isView = false;
        this.getMasterFormulaReports();
      }
    });
  }

}
