import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-process-step',
  templateUrl: './process-step.component.html',
  styleUrls: ['./process-step.component.css']
})
export class ProcessStepComponent implements OnInit {

  isNew = false;
  forms;
  processes;

  instruction = '';
  instructions = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getDosageForms();
    this.getProcesses();
  }

  getDosageForms() {
    this.service.get('qaDepartment.php?type=getDosageForms').subscribe(response => {
      this.forms = response;
    });
  }

  getProcesses() {
    this.service.get('qa.php?type=getManufacturingProcesses').subscribe(response => {
      this.processes = response;
    });
  }

  saveProcess(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    /* temp['instructions'] = this.instructions; */
    this.service.post('qa.php?type=saveManufacturingProcess', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        data.resetForm();
        alertify.success('Process Added Successfully');
        this.isNew = false;
        this.instructions = [];
        this.instruction = '';
        this.getProcesses();
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  addInstructions() {
    this.instructions[this.instructions.length] = this.instruction;
    this.instruction = '';
  }

  deleteInstruction(index) {
    this.instructions.splice(index, 1);
  }

}
