import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bom-approval',
  templateUrl: './bom-approval.component.html',
  styleUrls: ['./bom-approval.component.css']
})
export class BomApprovalComponent implements OnInit {

  isView = false;
  boms;
  logs;
  selected = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingPackingBOM();
    this.getPackingBOM();
  }

  getPendingPackingBOM() {
    this.service.get('packing.php?type=getPendingPackingBOM').subscribe(response => {
      this.boms = response;
    });
  }

  getPackingBOM() {
    this.service.get('packing.php?type=getPackingBOM').subscribe(response => {
      this.logs = response;
    });
  }

  view(index) {
    this.selected = this.boms[index];
    this.isView = true;
  }

  update(value) {
    this.service.get('packing.php?type=updatePackingBOM&status=' + value + '&id=' + this.selected['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Packing Data Sheet Updated Successfully');
        this.isView = false;
        this.getPackingBOM();
        this.getPendingPackingBOM();
      } else {
        alertify.error('An error occured, Please try again!');
      }
    });
  }

}
