import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-dispensing',
  templateUrl: './dispensing.component.html',
  styleUrls: ['./dispensing.component.css']
})
export class DispensingComponent implements OnInit {
  isView = false;
  results;
  selectedBMR = [];
  selectedIndex = -1;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingPackingBMR();
  }

  getPendingPackingBMR() {
    this.service.get('packing.php?type=getPackingMaterialDispensing').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    this.isView = true;
  }

}
