import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit {
  isView = false;
  results;
  selectedBMR = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingPackingBMR();
  }

  getPendingPackingBMR() {
    this.service.get('packing.php?type=getPendingPackingBMR').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedBMR = this.results[index];
    this.isView = true;
  }

  addRecord(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let pack_data = this.selectedBMR['pack_data'];
    pack_data[pack_data.length] = data.value;
    this.selectedBMR['pack_data'] = pack_data;
    data.resetForm();
  }

  savePackingRecords() {
    this.selectedBMR['packing_by'] = localStorage.getItem('emp_id');
    this.selectedBMR['packing_date'] = new Date().toLocaleDateString('en-CA');
    this.selectedBMR['status'] = 'active';
    this.selectedBMR['packing_status'] = 'done';
    this.service.post('packing.php?type=saveLineClearance&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Packing Material Dispensing saved successfully');
        this.getPendingPackingBMR();
        this.isView = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
