import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-requisition',
  templateUrl: './requisition.component.html',
  styleUrls: ['./requisition.component.css']
})
export class RequisitionComponent implements OnInit {
  isView = false;
  results;
  packings;
  selectedBMR = [];
  selectedIndex = -1;
  selectedPacking = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingPackingBMR();
  }

  getPendingPackingBMR() {
    this.service.get('bmr.php?type=getPendingPackingBMR').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    this.getPackingDataSheets(this.selectedBMR['product_code']);
    this.isView = true;
  }

  getPackingDataSheets(product_code) {
    this.service.get('packing.php?type=getPackingDataSheets&product_code=' + product_code).subscribe(response => {
      this.packings = response;
    });
  }

  getPackingData(index) {
    index = index - 1;
    this.selectedPacking = this.packings[index];
  }

  savePackingRequisition() {
    this.selectedBMR['requisition'] = 'done';
    this.selectedBMR['pack_bom'] = this.selectedPacking['id'];
    this.selectedBMR['pack_materials'] = this.selectedPacking['materials'];
    this.service.post('packing.php?type=savePackingRequisition', JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Packing Material Requisition send successfully');
        this.getPendingPackingBMR();
        this.isView = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });


  }

}
