import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-manufacturing-summary',
  templateUrl: './manufacturing-summary.component.html',
  styleUrls: ['./manufacturing-summary.component.css']
})
export class ManufacturingSummaryComponent implements OnInit {

  results;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getBatchPlanningLog').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.isNew = true;
  }

}
