import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Params } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-draft',
  templateUrl: './draft.component.html',
  styleUrls: ['./draft.component.css']
})
export class DraftComponent implements OnInit {

  isView = false;
  results;
  selectedResult = [];

  init = ({
    height: 300,
    menubar: true,
    content_style: 'body { font-size: 12pt; font-family: Times; }',
    plugins: [
      'advlist autolink lists link image charmap print preview anchor',
      'searchreplace visualblocks code fullscreen',
      'insertdatetime media table paste code help wordcount'
    ],
    toolbar:
      'formatselect | bold italic backcolor | \
      alignleft aligncenter alignright alignjustify | \
      bullist numlist outdent indent | removeformat | help'
  });
  api = 'lh5ymzb4rorw2zhscucerx1013ntad53j7jjnoiokc0pjg8v';

  cdepartments;
  departments;

  distributions = [];
  revisionList = [];
  distributionList = [];
  trainingList = [];

  isImpactQuality = false;
  constructor(private service: DataAccessService, public route: ActivatedRoute) { }

  ngOnInit(): void {
    this.route.params.subscribe(params => {
      if (params['id'] == 0) {
        this.getpendingdraft();
      } else {
        this.getpendingdraftrecord(params['id']);
      }
    });
    this.getDepartments();
    this.getChangeDepartments();
  }

  getpendingdraft() {
    this.service.get('sops.php?type=getpendingdraft').subscribe(response => {
      this.results = response;
    });
  }

  getpendingdraftrecord(id) {
    this.service.get('sops.php?type=getpendingdraftrecord&id=' + id).subscribe((response: any) => {
      this.selectedResult = response;
      this.isView = true;
    });
  }

  close() {
    this.getpendingdraft();
    this.isView = false;
  }

  view(index) {
    this.selectedResult = this.results[index];
    this.isView = true;
  }

  getDepartments() {
    this.service.get('sops.php?type=getDepartments').subscribe(response => {
      this.departments = response;
    });
  }

  getChangeDepartments() {
    this.service.get('changecontrol.php?type=getDepartments').subscribe((response:any) =>{
      this.cdepartments =  response;
    });
  }

  checkImpactQuality(value) {
    if (value === 'Yes') {
      this.isImpactQuality = true;
    } else {
      this.isImpactQuality = false;
    }
  }

  updateDept(value, i) {
    this.cdepartments[i].status = value;
  }

  save(data, data1) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }

    if (!data1.valid) {
      alertify.error('All fields are required');
      return;
    }

    let temp = data.value;
    temp['training'] = this.trainingList;
    temp['distribution'] = this.distributionList;
    temp['revision'] = this.revisionList;

    let test = [];
    for (let i = 0; i < this.cdepartments.length; i++) {
      let department = this.cdepartments[i];
      if (department['status']) {
        test[test.length] = department['department_name'];
      }
    }

    let temp1 = data1.value;
    let keys = Object.keys(temp1);
    for (let i = 0; i < keys.length; i++) {
      temp[keys[i]] = temp1[keys[i]];
    }

    temp['departments'] = test;
    this.service.post('sops.php?type=savedraft&id=' + this.selectedResult['id'], JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('saved successfully');
        data.resetForm();
        this.isView = false;
        this.getpendingdraft();
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }

  addRevision(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    this.revisionList[Object.keys(this.revisionList).length] = temp;
    data.resetForm();
  }

  deleteRevision(index) {
    this.revisionList.splice(index, 1);
  }

  addDistribution(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    this.distributionList[Object.keys(this.distributionList).length] = temp['department'];
    data.resetForm();
  }

  deleteDistribution(index) {
    this.distributionList.splice(index, 1);
  }

  addTraining(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    this.trainingList[Object.keys(this.trainingList).length] = temp['department'];
    data.resetForm();
  }

  deleteTraining(index) {
    this.trainingList.splice(index, 1);
  }

}
