<?php
// Database configuration
require 'db.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Connected successfully";
} catch(PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}

// Get the scanned employee ID from the Android app
$employeeIDAndroid = $_POST['emp_id_android']; // Assuming you are using POST

if (isset($employeeIDAndroid)) {
    // Check if there is a matching record in the 'id_attendance_android' table
    $checkAttendanceSQL = "SELECT * FROM id_attendance_android WHERE emp_id_android = :emp_id_android AND status = 'Absent'";
    $checkAttendanceStmt = $conn->prepare($checkAttendanceSQL);
    $checkAttendanceStmt->bindParam(':emp_id_android', $employeeIDAndroid, PDO::PARAM_STR);
    $checkAttendanceStmt->execute();
    
    if ($checkAttendanceStmt->rowCount() > 0) {
        // There is a matching record with status 'Absent', so update it to 'Present'
        $updateAttendanceSQL = "UPDATE id_attendance_android SET status = 'Present' WHERE emp_id_android = :emp_id_android";
        $updateAttendanceStmt = $conn->prepare($updateAttendanceSQL);
        $updateAttendanceStmt->bindParam(':emp_id_android', $employeeIDAndroid, PDO::PARAM_STR);
        $updateAttendanceStmt->execute();
        
        // Respond to the Android app
        $response = array('message' => 'Status updated to Present');
        echo json_encode($response);
    } else {
        // No matching record with status 'Absent'
        $response = array('message' => 'No matching record with status Absent');
        echo json_encode($response);
    }
} else {
    $response = array('message' => 'No data received from the Android app');
    echo json_encode($response);
}
?>
