<?php
// CORS headers (always, at very top)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit(0);
}

ini_set('display_errors', 1); error_reporting(E_ALL);

require './db.php';
require './token.php';
require './tcpdf/tcpdf.php';

date_default_timezone_set("Asia/Kolkata");

// Helper functions
function getParam($key, $default = '') {
    return isset($_GET[$key]) ? $_GET[$key] : $default;
}
function jsonResponse($data, $statusCode=200) {
    header('Content-Type: application/json');
    http_response_code($statusCode);
    echo json_encode($data);
    exit;
}
$token = getParam("token");
$timestamp = time();
$entry_date = date("Y-m-d H:i:s", $timestamp);
$input = json_decode(file_get_contents('php://input'), true);

$sql = "SELECT * FROM token WHERE token=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();
$_GET["emp_id"] = "";
$_GET["department"] = "";

if($result->num_rows > 0){
    $row = $result->fetch_assoc();
    $string = decrypt('decrypt', $token, $row["key1"], $row["key2"]);
    $string = explode("$", $string);
    $_GET["emp_id"] = $string[0];
    $_GET["department"] = $string[1];

    $txt = json_encode([
        "process"     => "FRONTEND",
        "token"       => $token,
        "action"      => getParam("type"),
        "actiontime"  => $entry_date,
        "department"  => $_GET["department"],
        "emp_id"      => $_GET["emp_id"],
        "method"      => $_SERVER['REQUEST_METHOD'],
        "REMOTE_ADDR" => $_SERVER['REMOTE_ADDR']
    ]);
    @file_put_contents('../logs.txt', $txt.PHP_EOL, FILE_APPEND | LOCK_EX);

    $type = getParam("type");
    switch ($type) {
        case 'get_Equipments':
            $output = [];
            $plant_id = getParam("plant_id");
            $depart = getParam("depart");
            $sql = "SELECT * FROM equipment WHERE plant_id=? AND department=? ORDER BY equipment_name";
            $stmt = $conn->prepare($sql); $stmt->bind_param("ss", $plant_id, $depart);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'getSECTIONS':
            $output = [];
            $department1 = getParam("department1");
            $sql = "SELECT * FROM section WHERE department=? ORDER BY section_name";
            $stmt = $conn->prepare($sql); $stmt->bind_param("s", $department1);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'getproductName':
            $output = [];
            $plant_id = getParam("plant_id");
            $sql = "SELECT product_name,product_code,grade FROM product WHERE plant_id=?";
            $stmt = $conn->prepare($sql); $stmt->bind_param("s", $plant_id);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'get_Eqgetemployee_byDeptipments':
            $output = [];
            $plant_id = getParam("plant_id");
            $depart = getParam("depart");
            $sql = "SELECT firstname AS emp_name,emp_id,department,designation FROM employee WHERE status='Active' AND plant_id=? AND department=? ORDER BY firstname ASC";
            $stmt = $conn->prepare($sql); $stmt->bind_param("ss", $plant_id, $depart);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'savetemperhumrec':
            $sql = "INSERT INTO temperhumrec (plant_id,department,month,room_no,date,time,temperature,humidity,done_by,donebyDate,entry_by,entry_date,remark) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssssssssssss", $input['plant_id'], $input['department'], $input['tempmon'], $input['section'], $input['date'], $input['timeinhr'], $input['temp'], $input['humidity'], $input['done_by'], $input['donebyDate'], $_GET['emp_id'], $entry_date, $input['remark']);
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed"],500);
            break;
        case 'savePressurediff':
            $sql = "INSERT INTO pressurediffrential (plant_id,department,month,room_no,date,time,temperature,done_by,donebyDate,entry_by,entry_date,remark) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssssssssss", $input['plant_id'], $input['department'], $input['tempmon'], $input['section'], $input['date'], $input['timeinhr'], $input['pressure'], $input['done_by'], $input['donebyDate'], $_GET['emp_id'], $entry_date, $input['remark']);
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed"],500);
            break;
        case 'get_Equipments_byCode':
            $output = [];
            $plant_id = getParam("plant_id");
            $equip_code = getParam("equipment_code");
            $sql = "SELECT * FROM equipment WHERE plant_id=? AND equipment_code=? ORDER BY equipment_name";
            $stmt = $conn->prepare($sql); $stmt->bind_param("ss", $plant_id, $equip_code);
            $stmt->execute(); $result = $stmt->get_result();
            if ($row = $result->fetch_assoc()) jsonResponse($row);
            else jsonResponse((object)[]);
            break;
        case 'save_equipment_usage_cleaning_record':
            $sql = "INSERT INTO equipment_usage_cleaning_record (department,plant_id,equipment_name,equipment_code,date,activity,productYesNo,productName,cleaningType,batchNo,startTime,endTime,doneBy,doneOn,entry_by,entry_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssssssssssssss", $input['department'], $_GET['plant_id'], $input['equipment_name'], $input['equipment_code'], $input['date'], $input['activity'], $input['productYesNo'], $input['productName'], $input['cleaningType'], $input['batchNo'], $input['startTime'], $input['endTime'], $input['doneBy'], $input['doneOn'], $_GET['emp_id'], $entry_date);
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed", "error"=>$stmt->error],500);
            break;
        case 'get_area_cleaning_Checking':
            $output = [];
            $depart = getParam("depart");
            $sql = "SELECT * FROM temperhumrec WHERE status='pending' AND department=?";
            $stmt = $conn->prepare($sql); $stmt->bind_param("s", $depart);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'get_PressureDiff_Checking':
            $output = [];
            $depart = getParam("depart");
            $sql = "SELECT * FROM pressurediffrential WHERE status='pending' AND department=?";
            $stmt = $conn->prepare($sql); $stmt->bind_param("s", $depart);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'get_save_equipment_usage_cleaning_record':
            $output = [];
            $depart = getParam("depart");
            $activity = getParam("Activity_type");
            $sql = "SELECT * FROM equipment_usage_cleaning_record WHERE status='pending' AND department=? AND activity=?";
            $stmt = $conn->prepare($sql); $stmt->bind_param("ss", $depart, $activity);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'update_equipment_usage_cleaning_record':
            $sql = "UPDATE equipment_usage_cleaning_record SET status=?, checked_by=?, checked_date=? WHERE id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $input['status'], $_GET['emp_id'], $entry_date, $input['id']);
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed"],500);
            break;
        case 'update_Pressure_record':
            $sql = "UPDATE pressurediffrential SET status=?, checked_by=?, checked_date=? WHERE id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $input['status'], $_GET['emp_id'], $entry_date, $input['id']); 
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed"],500);
            break;
        case 'getTempratureHumidityChecking':
            $output = [];
            $depart = getParam("depart");
            $plant_id = getParam("plant_id");
            $sql = "SELECT * FROM temperhumrec WHERE department=? AND status='pending' AND plant_id=?";
            $stmt = $conn->prepare($sql); $stmt->bind_param("ss", $depart, $plant_id);
            $stmt->execute(); $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) $output[] = $row;
            jsonResponse($output);
            break;
        case 'update_Temprature_humidty_record':
            $sql = "UPDATE temperhumrec SET status=?, checked_by=?, CheckedbyDate=? WHERE id=?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $input['status'], $_GET['emp_id'], $entry_date, $input['id']);
            if ($stmt->execute()) jsonResponse(["status"=>"success"]);
            else jsonResponse(["status"=>"failed"],500);
            break;
        default:
            jsonResponse(['status' => 'Invalid type!'],400);
    }

} else {
    jsonResponse(['status' => 'Invalid Token!'],401);
}

$conn->close();
?>
