<?php
// Define your database connection parameters
$db_host= "142.4.9.25";
$db_user= "cpplgmp_admin";
$db_pass= "Cppl@1979";
$db_name= "cpplgmp_olive";
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle POST request
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the JSON data sent from the Android app
    $json_data = file_get_contents("php://input");
    $data = json_decode($json_data, true);

    // Process each entry in the JSON array
    foreach ($data as $person) {
        $name = $person['name'];
        $face = base64_decode($person['face']);
        $templates = base64_decode($person['templates']);

        // Insert data into database
        $sql = "INSERT INTO  persondata(name, face, templates) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sbb", $name, $face, $templates);
        $stmt->execute();
    }

    // Send response back to Android app
    echo "Data saved successfully";
} else {
    // Handle GET request (for retrieving data from the database)
    $sql = "SELECT name, face, templates FROM persondata";
    $result = $conn->query($sql);

    // Prepare JSON response array
    $response = array();

    if ($result->num_rows > 0) {
        // Output data of each row
        while ($row = $result->fetch_assoc()) {
            // Prepare each person entry
            $person = array(
                "name" => $row["name"],
                "face" => base64_encode($row["face"]),
                "templates" => base64_encode($row["templates"])
            );
            // Add person to response array
            $response[] = $person;
        }
    }

    // Send JSON response back to Android app
    header('Content-Type: application/json');
    echo json_encode($response);
}

// Close connection
$conn->close();
?>
