<?php
require '../db.php';
require '../token.php';
require '../tcpdf/tcpdf.php';

class MYPDF extends TCPDF {
        public function Header() {
            
        }
        public function Footer() {
            $this->SetY(-15);
            $this->SetFont('helvetica', 'N', 10);
            $this->Cell(0, 5, 'Generated By- '.$_GET['emp_id'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
             $this->SetY(-15);
            $this->SetFont('helvetica', 'N', 10);
            $this->Cell(0, 5, date("m/d/Y h:i:s"), 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $this->SetY(-15);
            $this->SetFont('helvetica', 'N', 10);
            $this->Cell(0, 5, 'Page '. $this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
            
        }
    }
    
    $pdf = new MYPDF (PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins(15, 15, 15, 15);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
        require_once(dirname(__FILE__).'/lang/eng.php');
        $pdf->setLanguageArray($l);
    }
    if($_GET['pageset'] != ''){
        $pdf->AddPage($_GET['pageset'], 'A4');
    }
    else{
        $pdf->AddPage('P', 'A4');
    }
    $pdf->SetY(10);
    $pdf->SetFont ('Times', '', '11' , '', 'default', true );
    $data = file_get_contents("../bmr.json");
    $data = json_decode($data, true);
    $data = $data[$_GET["bmr_no"]];
    $html='
    <style>
    table tr td {
        border:solid 1px BCBBBA;
    }
    </style>
    <table cellpadding="5">
        <thead>
            <tr>
                <td style="width:62%;"><b style="font-size:20px;">DEMO</b> Chemicals &amp; Laboratories (P) Ltd. <br>W – 302, Adarsh Colony, Tingare Nagar,<br>Vishrantwadi, Dist – PUNE – 411 015.</td>
                <td style="width:38%; text-align:center;">BATCH MANUFACTURING RECORD – '.$data['product_name'].'</td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="width:16%;">Prepared by</td>
                <td style="width:20%;">PDN Supervisor</td>
                <td style="width:13%;"></td>
                <td style="width:13%;"></td>
                <td style="width:16%;">Issue Date</td>
                <td style="width:22%;"></td>
            </tr>
            <tr>
                <td>Checked by</td>
                <td>PDN Head</td>
                <td></td>
                <td></td>
                <td>Effective Date</td>
                <td></td>
            </tr>
            <tr>
                <td>Approved by</td>
                <td>QA Head</td>
                <td></td>
                <td></td>
                <td>Revision No.</td>
                <td></td>
            </tr>
            <tr>
                <td>SOP No.  :</td>
                <td colspan="3">DNS/PDN/SOP/051</td>
                <td>Revision Date</td>
                <td></td>
            </tr>
            <tr>
                <td>MFR No. :</td>
                <td colspan="3">'.$data['mfr_no'].'</td>
                <td colspan="2"><b>Shelf Life :</b> '.$data['shelf_life'].'</td>
            </tr>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr>
                <td colspan="2">Batch Starting Date : '.$data['start_date'].'</td>
                <td colspan="2">Batch Completion Date : '.$data['complete_date'].'</td>
            </tr>
            <tr>
                <td colspan="2">Issued BMR No. : </td>
                <td colspan="2">Issued by (Sign & Date)</td>
            </tr>
            <tr><td style="border:none;" colspan="4"></td></tr>
            <tr>
                <td colspan="4" style="border:none;"><b style="text-align: center">'.$num_pages.' RAW MATERIAL REQUISITION SHEET</b></td>
            </tr>
            <tr>
                <td style="width:8%;">Sr. No</td>
                <td style="width:32%;">Name of Material</td>
                <td style="width:20%;">Standard Qty.</td>
                <td style="width:20%;">Qty. Required</td>
                <td style="width:20%;">AR. No.</td>
            </tr>';
            $lots = $data["lots"];
            for ($i = 0; $i < count($lots); $i++) {
                $temp = $lots[$i];
                $materials = $temp['materials'];
                for ($j = 0; $j < count($materials); $j++) {
                    $material = $materials[$j];
                    if ($j == 0) {
                        $html.='
                        <tr>
                            <td rowspan="'.count($materials).'">Lot No. '.$temp['lot_no'].'</td>
                            <td>'.$material['material_name'].'</td>
                            <td>'.$material['qty'].' '.$material['unit'].'</td>
                            <td>'.$material['required_qty'].'</td>
                            <td>'.$material['ar_no'].'</td>
                        </tr>
                        ';
                    } else {
                        $html.='
                        <tr>
                            <td>'.$material['material_name'].'</td>
                            <td>'.$material['qty'].' '.$material['unit'].'</td>
                            <td>'.$material['required_qty'].'</td>
                            <td>'.$material['ar_no'].'</td>
                        </tr>
                        ';
                    }
                }
            }
            $html.= '
            <tr>
                <td style="border:none;" colspan="5"></td>
            </tr>';
            for ($a = 0; $a < count($lots); $a++) {
                $temp = $lots[$a];
                $html.='
                <br pagebreak="true"/>
                <tr>
                    <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                    <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                    <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                    <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                </tr>
                <tr>
                    <td style="border:none; text-align:center;" colspan="4">
                        <br><br><br><br><br>
                        <h1>LOT No. '.$temp['lot_no'].' </h1>
                    </td>
                </tr>
                <br pagebreak="true"/>
                <tr>
                    <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                    <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                    <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                    <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                </tr>
                <tr><td colspan="4" style="border:none;"></td></tr>
                <tr>
                    <td colspan="4" style="border:none;"><b style="text-align: center">LINE CLEARANCE FOR DISPENSING OF RAW MATERIAL</b></td>
                </tr>
                <tr>
                    <td style="width:8%;">Sr. No</td>
                    <td style="width:39%;">Check Points</td>
                    <td style="width:20%;">Observations<br>(OK / Not OK)</td>
                    <td style="width:33%;">Remarks</td>
                </tr>';
                $lineclearance = $temp['lineclearance'];
                $dispensing = $lineclearance['dispensing'];
                $checkpoints = $dispensing["checkpoints"];
                $sr_no = 1;
                for ($i = 0; $i < count($checkpoints); $i++) {
                    $html.='
                    <tr>
                        <td>'. $sr_no++.'</td>
                        <td>'.$checkpoints[$i]['checkpoint'].'</td>
                        <td style="text-align:center;">'.$checkpoints[$i]['observation'].'</td>
                        <td>'.$checkpoints[$i]['remark'].'</td>
                    </tr>';
                }
                $html.='
                <tr>
                    <td colspan="4"></td>
                </tr>
                <tr>
                    <td style="width:15%;">Checked By</td>
                    <td style="width:21%;">Warehouse</td>
                    <td style="width:31%;"></td>
                    <td style="width:33%;"></td>
                </tr>
                <tr>
                    <td>Checked By</td>
                    <td>Production</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="4">Before dispensing of raw materials operation begun, I certify that all the above points in the Check List are complied.</td>
                </tr>
                <tr>
                    <td>Verified By</td>
                    <td>Quality Assurance</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr><td colspan="4" style="border:none;"></td></tr>
                <br pagebreak="true"/>
                <tr>
                    <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                    <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                    <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                    <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                </tr>
                <tr><td colspan="4" style="border:none;"></td></tr>
                <tr>
                    <td colspan="4" style="border:none; text-align:center;"><b>DISPENSING SHEET / CALCULATION SHEET</b></td>
                </tr>';
                $materials = $temp['materials'];
                for ($j = 0; $j < count($materials); $j++) {
                    $material = $materials[$j];
                    $html.='
                    <tr>
                        <td rowspan="2" style="width:8%;">Sr. No.</td>
                        <td style="width:46%;">'.$material['material_name'].'</td>
                        <td style="width:46%;">AR No.: '.$material['ar_no'].'</td>
                    </tr>
                    <tr>
                        <td style="width:20%;">Gross Wt. ('.$material['unit'].')</td>
                        <td style="width:18%;">Tare Wt. ('.$material['unit'].')</td>
                        <td style="width:18%;">Net Wt. ('.$material['unit'].')</td>
                        <td style="width:18%;">Weighed By</td>
                        <td style="width:18%;">Checked By</td>
                    </tr>';
                    $dispensing = $material['dispensing'];
                    $srno= 0;
                    for ($k = 0; $k < count($dispensing); $k++) {
                        $srno++;
                        $html.='
                        <tr>
                            <td>'.$srno.'</td>
                            <td style="text-align:center;">'.$dispensing[$k]['gross_wt'].'</td>
                            <td style="text-align:center;">'.$dispensing[$k]['tare_wt'].'</td>
                            <td style="text-align:center;">'.$dispensing[$k]['net_wt'].'</td>
                            <td style="text-align:center;">'.$dispensing[$k]['weight_by'].'</td>
                            <td style="text-align:center;">'.$dispensing[$k]['check_by'].'</td>
                        </tr>';
                    }
                }    
                    
                    $html.='
                    <tr>
                        <td></td>
                        <td colspan="2"></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="5" style="border:none;"></td>
                    </tr>
                    <br pagebreak="true"/>
                    <tr>
                        <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                        <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                        <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                        <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <tr>
                        <td colspan="4" style="border:none;"><b style="text-align: center">LINE CLEARANCE FOR MANUFACTURING OPERATION</b></td>
                    </tr>
                    <tr>
                        <td style="width:8%;">Sr. No</td>
                        <td style="width:39%;">Check Points</td>
                        <td style="width:20%;">Observations<br>(OK / Not OK)</td>
                        <td style="width:33%;">Remarks</td>
                    </tr>';
                    $lineclearance = $temp["lineclearance"];
                    $manufacturing = $lineclearance['manufacturing'];
                    $checkpoints = $manufacturing["checkpoints"];
                    $sr_no = 1;
                    for ($i = 0; $i < count($checkpoints); $i++) {
                        $html.='
                        <tr>
                            <td>'. $sr_no++.'</td>
                            <td>'.$checkpoints[$i]['checkpoint'].'</td>
                            <td style="text-align:center;">'.$checkpoints[$i]['observation'].'</td>
                            <td>'.$checkpoints[$i]['remark'].'</td>
                        </tr>';
                    }
                    $html.='
                    <tr>
                        <td colspan="4"></td>
                    </tr>
                    <tr>
                        <td style="width:15%;">Checked By</td>
                        <td style="width:21%;">Warehouse</td>
                        <td style="width:31%;"></td>
                        <td style="width:33%;"></td>
                    </tr>
                    <tr>
                        <td>Checked By</td>
                        <td>Production</td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="4">Before dispensing of raw materials operation begun, I certify that all the above points in the Check List are complied.</td>
                    </tr>
                    <tr>
                        <td>Verified By</td>
                        <td>Quality Assurance</td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <br pagebreak="true"/>
                    <tr>
                        <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                        <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                        <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                        <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <tr>
                        <td colspan="4" style="border:none; text-align:center;"><b>EQUIPMENT CLEANING RECORD</b></td>
                    </tr>
                    <tr>
                        <td style="width:6%;">Sr. No.</td>
                        <td style="width:12%;">Date</td>
                        <td style="width:12%;">Machine / Equipment</td>
                        <td style="width:12%;">Code No</td>
                        <td style="width:12%;">Previous Product & Batch No. </td>
                        <td style="width:12%;">SOP. No.</td>
                        <td style="width:11%;">Cleaned by</td>
                        <td style="width:12%;">Checked By Prod.</td>
                        <td style="width:11%;">Verified By QA </td>
                    </tr>';
                    $equipment_cleaning = $temp["equipment_cleaning"];
                    $srno =1;
                    for ($i = 0; $i < count($equipment_cleaning); $i++) {
                        $html.='
                        <tr>
                            <td>'.$srno++.'</td>
                            <td>'.$equipment_cleaning[$i]['date'].'</td>
                            <td>'.$equipment_cleaning[$i]['equipment_name'].'</td>
                            <td>'.$equipment_cleaning[$i]['equipment_code'].'</td>
                            <td>'.$equipment_cleaning[$i]['previous_product'].'</td>
                            <td>'.$equipment_cleaning[$i]['sop_no'].'</td>
                            <td>'.$equipment_cleaning[$i]['clean_by'].'</td>
                            <td>'.$equipment_cleaning[$i]['check_by'].'</td>
                            <td>'.$equipment_cleaning[$i]['approve_by'].'</td>
                        </tr>';
                    }
                    
                        $html.='
                            <tr><td colspan="4" style="border:none;"></td></tr>
                        <br pagebreak="true"/>
                        <tr>
                            <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                            <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                            <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                            <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                        </tr>
                        <tr><td colspan="4" style="border:none;"></td></tr>
                            <tr><td style="border:none; text-align:center;" colspan="4"><b>MANUFACTURING PROCESS SHEET</b></td></tr>
                            <tr>
                                <td rowspan="2" style="width:6%">Sr. No</td>
                                <td rowspan="2" style="width:25%;">Manufacturing step</td>
                                <td rowspan="2" style="width:10%">Machine ID. no </td>
                                <td rowspan="2" style="width:12%">Date</td>
                                <td colspan="2" style="width:16%">Time</td>
                                <td rowspan="2" style="width:9%">Reaction Temp</td>
                                <td rowspan="2" style="width:11%">Done By</td>
                                <td rowspan="2" style="width:10%">Checked by</td>
                            </tr>
                        <tr>
                            <td>From</td>
                            <td>To</td>
                        </tr>';
                        $temp = $lots[$i];
                        $manufacturing = $temp['manufacturing'];
                        $srno = 1;
                        for ($j = 0; $j < count($manufacturing); $j++) {
                            $material = $manufacturing[$j];
                            $html.='
                            <tr>
                                <td>'.$srno++.'</td>
                                <td>'.$material['procedure'].'</td>
                                <td>'.$material['equipment_code'].'</td>
                                <td>'.$material['date'].'</td>
                                <td>'.$material['from_time'].'</td>
                                <td>'.$material['to_time'].'</td>
                                <td>'.$material['temp'].'</td>
                                <td>'.$material['done_by'].'</td>
                                <td>'.$material['check_by'].'</td>
                            </tr>
                            ';
                        }
                        
                    $html.='
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <br pagebreak="true"/>
                    <tr>
                        <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                        <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                        <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                        <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <tr><td colspan="4" style="border:none; text-align:center;"><b>DRYING RECORD</b></td></tr>
                    <tr>
                        <td style="width:50%; border:none;">Dryer No.: </td>
                        <td style="width:50%; border:none;">Total Drying Time: </td>
                    </tr>
                    <tr>
                        <td rowspan="2" style="width:15%">Date</td>
                        <td rowspan="2" style="width:17%">Part No.</td>
                        <td colspan="2" style="width:17%">Time</td>
                        <td rowspan="2" style="width:17%">Drying Temp.</td>
                        <td rowspan="2" style="width:17%">Done By </td>
                        <td rowspan="2" style="width:17%">Checked by</td>
                    </tr>
                    <tr>
                        <td>From</td>
                        <td>To</td>
                    </tr>';
                    $dryingdata = $temp['drying'];
                    for ($j = 0; $j < count($dryingdata); $j++) {
                    $html.='
                    <tr>
                        <td>'.$dryingdata[$j]['date'].'</td>
                        <td>'.$dryingdata[$j]['part_no'].'</td>
                        <td>'.$dryingdata[$j]['from_time'].'</td>
                        <td>'.$dryingdata[$j]['to_time'].'</td>
                        <td>'.$dryingdata[$j]['temp'].'</td>
                        <td>'.$dryingdata[$j]['done_by'].'</td>
                        <td>'.$dryingdata[$j]['check_by'].'</td>
                    </tr>
                    ';
                    }
                    $html.='
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <br pagebreak="true"/>
                    <tr>
                        <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                        <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                        <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                        <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>
                    <tr>
                        <td colspan="4" style="border:none; text-align:center;"><b>YIELD DETAILS</b></td>
                    </tr>
                    <tr style="text-align:center;">
                        <td colspan="4" style="width:60%;"><b>Unit Operations</b></td>
                        <td rowspan="2" style="width:20%"><b>No of Unit Operations</b></td>
                        <td rowspan="2" style="width:20%"><b>Qty (Kg)</b></td>
                    </tr>
                    <tr style="text-align:center;">
                        <td>CF</td>
                        <td>FBD</td>
                        <td>TD</td>
                        <td>RVD</td>
                    </tr>
                    <tr style="text-align:center;">
                        <td>'.$temp['cf'].'</td>
                        <td>'.$temp['fbd'].'</td>
                        <td>'.$temp['td'].'</td>
                        <td>'.$temp['rvd'].'</td>
                        <td>'.$temp['operations'].'</td>
                        <td>'.$temp['yield'].'</td>
                    </tr>
                    <tr>
                        <td colspan="7">
                            <table cellpadding="5">
                                <tr>
                                    <td style="border:none; width:50%;">Total Qty. manufactured (A)</td>
                                    <td style="border:none; width:10%;">= '.$temp['yield'].' Kg</td>
                                    <td style="border:none; width:15%;"></td>
                                    <td style="border:none; width:25%;"></td>
                                </tr>
                                <tr>
                                    <td style="border:none;">Sampled Qty. given to QC (CF) (B)</td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;">'.$temp['cf'].' X   0.025 =</td>
                                    <td style="border:none;">Kg</td>
                                </tr>
                                <tr>
                                    <td style="border:none;">Sampled Qty. given to QC (FBD) (C)</td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;">'.$temp['fbd'].' X	0.025  =</td>
                                    <td style="border:none;">Kg</td>
                                </tr>
                                <tr>
                                    <td style="border:none;">Sampled Qty. given to QC (TD / RVD) (D)</td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;">'.$temp['td'].' X	0.025  =</td>
                                    <td style="border:none;">	Kg</td>
                                </tr>
                                <tr>
                                    <td style="border:none;">Actual Qty. for blending [E = (A – (B + C+D))]</td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;">'.$temp['yield'].'</td>
                                    <td style="border:none;"> Kg</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="width:21%;">RM (Base) for Calculation</td>
                        <td style="width:13%;">Yield Ratio</td>
                        <td style="width:13%;">Theoretical Yield</td>
                        <td style="width:13%;">Actual Yield</td>
                        <td style="width:40%;" rowspan="2">
                            <table>
                                <tr>
                                    <td style="width:34%; border:none;">Yield (in %)</td>
                                    <td style="width:5%; border:none;">=</td>
                                    <td style="border:none;"> (Actual Yield)/(Theorotical Yield ) X 100</td>
                                </tr>
                                <tr>
                                    <td style="border:none;"></td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;"> (                        )/(                           ) X 100</td>
                                </tr>
                                <tr>
                                    <td style="border:none;"></td>
                                    <td style="border:none;">=</td>
                                    <td style="border:none;">                     %</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr><td colspan="4" style="border:none;"></td></tr>';
                
            }
                    $html .= '
                    <tr><td colspan="4" style="border:none;"></td></tr>
                <br pagebreak="true"/>
                <tr>
                    <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                    <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                    <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                    <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
                </tr>
                <tr><td colspan="4" style="border:none;"></td></tr>
                <tr>
                    <td style="border:none; text-align:center;" colspan="4"><b>LINE CLEARANCE FOR BLENDING OPERATION</b></td>
                </tr>
                <tr>
                    <td style="width:8%;">Sr. No</td>
                    <td style="width:39%;">Check Points</td>
                    <td style="width:20%;">Observations<br>(OK / Not OK)</td>
                    <td style="width:33%;">Remarks</td>
                </tr>';
            $lineclearance = $data["lineclearance"];
            $blending = $lineclearance['blending'];
            $checkpoints = $blending["checkpoints"];
            $sr_no = 1;
            for ($i = 0; $i < count($checkpoints); $i++) {
            $html.='
            <tr>
                <td>'. $sr_no++.'</td>
                <td>'.$checkpoints[$i]['checkpoint'].'</td>
                <td style="text-align:center;">'.$checkpoints[$i]['observation'].'</td>
                <td>'.$checkpoints[$i]['remark'].'</td>
            </tr>';
            }
            $html.='
            <tr>
                <td colspan="4"></td>
            </tr>
            <tr>
                <td style="width:15%;">Checked By</td>
                <td style="width:21%;">Warehouse</td>
                <td style="width:31%;"></td>
                <td style="width:33%;"></td>
            </tr>
            <tr>
                <td>Checked By</td>
                <td>Production</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="4">Before dispensing of raw materials operation begun, I certify that all the above points in the Check List are complied.</td>
            </tr>
            <tr>
                <td>Verified By</td>
                <td>Quality Assurance</td>
                <td></td>
                <td></td>
            </tr>
            <tr><td colspan="8" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>BLENDING OPERATION </b></td>
            </tr>
            <tr>
                <td style="width:6%;" rowspan="2">Sr. No.</td>
                <td style="width:26%;" rowspan="2">Manufacturing Steps</td>
                <td style="width:12%;" rowspan="2">Machine / Equipment</td>
                <td style="width:12%;" rowspan="2">Date</td>
                <td style="width:14%;" colspan="2">Time</td>
                <td style="width:10%;" rowspan="2">Reaction Temp</td>
                <td style="width:10%;" rowspan="2">Done By</td>
                <td style="width:10%;" rowspan="2">Checked by</td>
            </tr>
            <tr>
                <td>From</td>
                <td>To</td>
            </tr>';
            $blending = $data["blending"];
            $srno =1;
            for ($i = 0; $i < count($blending); $i++) {
                $html.='
                <tr>
                    <td>'.$srno++.'</td>
                    <td>'.$blending[$i]['procedure'].'</td>
                    <td>'.$blending[$i]['equipment_code'].'</td>
                    <td>'.$blending[$i]['date'].'</td>
                    <td>'.$blending[$i]['from_time'].'</td>
                    <td>'.$blending[$i]['to_time'].'</td>
                    <td>'.$blending[$i]['temp'].'</td>
                    <td>'.$blending[$i]['check_by'].'</td>
                    <td>'.$blending[$i]['check_by'].'</td>
                </tr>';
            }
            $html.='
            <tr><td colspan="4" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>PACKING MATERIAL REQUISITION</b></td>
            </tr>
            <tr style="font-weight:bold;">
                <td style="width:8%;">Sr. No.</td>
                <td style="width:32%;">Item</td>
                <td style="width:15%;">Quantity Required</td>
                <td style="width:15%;">AR No</td>
                <td style="width:15%;">Requisition given By Production</td>
                <td style="width:15%;">Issued By Stores</td>
            </tr>';
            $pack_materials = $data["pack_materials"];
            $srno = 1;
            for($i= 0; $i < count($pack_materials); $i++){
            $html.='
            <tr>
                <td>'.$srno++.'</td>
                <td>'.$pack_materials[$i]['material_name'].'</td>
                <td>'.$pack_materials[$i][''].'</td>
                <td>'.$pack_materials[$i][''].'</td>
                <td>'.$pack_materials[$i][''].'</td>
                <td>'.$pack_materials[$i][''].'</td>
            </tr>';
            }
            $html.='
            <tr><td colspan="6" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>LINE CLEARANCE FOR PACKING OPERATION</b></td>
            </tr>
            <tr>
                <td style="width:8%;">Sr. No</td>
                <td style="width:39%;">Check Points</td>
                <td style="width:20%;">Observations<br>(OK / Not OK)</td>
                <td style="width:33%;">Remarks</td>
            </tr>';
            $lineclearance = $data["lineclearance"];
            $packing = $lineclearance['packing'];
            $checkpoints = $packing["checkpoints"];
            $sr_no = 1;
            for ($i = 0; $i < count($checkpoints); $i++) {
            $html.='
            <tr>
                <td>'. $sr_no++.'</td>
                <td>'.$checkpoints[$i]['checkpoint'].'</td>
                <td style="text-align:center;">'.$checkpoints[$i]['observation'].'</td>
                <td>'.$checkpoints[$i]['remark'].'</td>
            </tr>';
            }
            $html.='
            <tr>
                <td style="width:23%">Checked By</td>
                <td style="width:24%">Production</td>
                <td style="width:20%;"></td>
                <td style="width:33%;"></td>
            </tr>
            <tr>
                <td colspan="4">Before packing operation begun, I certify that all the above points in the Check List are complied</td>
            </tr>
            <tr>
                <td>Verified By</td>
                <td>Quality Assurance</td>
                <td></td>
                <td></td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>PACKED GOODS VERIFICATION RECORD</b></td>
            </tr>
            <tr>
                <td style="width:33.33%;">Date of Packing</td>
                <td style="width:33.33%;">Packing Done By</td>
                <td style="width:33.33%;">Packing Checked By</td>
            </tr>
            <tr>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <tr><td colspan="3"></td></tr>
            <tr>
                <td style="width:12%;">Drum/ Bag No.</td>
                <td style="width:12%;">Gross Wt.Kg </td>
                <td style="width:12%;">Tare Wt. Kg </td>
                <td style="width:12%;">Net Wt.Kg </td>
                <td style="width:13%;">Bag / Drum Printing</td>
                <td style="width:13%;">Tying Thread / Temper seal</td>
                <td style="width:13%;">Bag sewing / Drum seal</td>
                <td style="width:13%;">Preprinted label / shipping mark</td>
            </tr>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Dept.</td>
                <td style="width:29%;">Production</td>
                <td style="width:29%;">Warehouse</td>
                <td style="width:30%;">Quality Assurance</td>
            </tr>
            <tr>
                <td>Sign.</td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Date.</td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>BLENDING DETAILS</b></td>
            </tr>
            <tr>
                <td colspan="4" style="border:none;">Batch # ___________________ Preparation</td>
            </tr>
            <tr style="font-weight:bold;">
                <td style="width:50%;">Blending Details</td>
                <td style="width:25%;">Qty. (In Kg)</td>
                <td style="width:25%;">Remarks</td>
            </tr>
            <tr>
                <td>Actual Qty. for Blending  Lot # (01 -     )(E)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Previous Balance Qty. (B #                   ) with production (F)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Previous Balance Qty. (B #                  ) with Warehouse (G)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Total Qty. Blended  (H = E + F + G)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Finished Product Sample (for Analysis), (1 x 0.050 Kg) (I)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Finished Product Sample (Controlled Sample) (3 x 0.050 Kg), (J)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Finished Product Sample (for Stability) (3 x 0.050 Kg) (K)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Qty. Packed (              Kg     x            Nos) (L)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Balance Qty. (M)</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td>Blending Loss [H – (I + J + K+ L+M)]</td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td style="border:none;" colspan="3">Quantity transfer to B.S.R.<br>Intimation No. ____________________ dated _______________.</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <br pagebreak="true"/>
            <tr>
                <td style="width:25%;">Batch No. '.$data['batch_no'].'</td>
                <td style="width:25%;">Batch Size. '.$data['batch_size'].'</td>
                <td style="width:25%;">Mfg. Date. '.$data['mfg_date'].'</td>
                <td style="width:25%;">Exp. Date. '.$data['exp_date'].'</td>
            </tr>
            <tr><td colspan="4" style="border:none;"></td></tr>
            <tr>
                <td colspan="4" style="border:none; text-align:center;"><b>PRODUCT DESPATCH SHEET</b></td>
            </tr>
            <tr>
                <td style="width:14%">No of Dispatch</td>
                <td style="width:14%">Date</td>
                <td style="width:14%">Qty Dispatched</td>
                <td style="width:14%">Party name/code</td>
                <td style="width:14%">Qty. Balance</td>
                <td style="width:15%">Sign. By Warehouse</td>
                <td style="width:15%">Remarks</td>
            </tr>
        </tbody>
    </table>
    <div></div>';
EOD;
$pdf->writeHTML($html, true, false, false, false, '');
$pdf->Output('BMR.pdf', 'I');
?>