<?php
// Check if a file has been uploaded
if(isset($_FILES['faceImage']) && $_FILES['faceImage']['error'] == 0) {
    $name = $_POST['name']; // Assuming you're passing the name along with the image
    $targetDir = "uploads/"; // Directory where you want to save the images
    $targetFile = $targetDir . basename($_FILES['faceImage']['name']);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

    // Check if the image file is a actual image or fake image
    $check = getimagesize($_FILES['faceImage']['tmp_name']);
    if($check !== false) {
        echo "File is an image - " . $check['mime'] . ".";
        $uploadOk = 1;
    } else {
        echo "File is not an image.";
        $uploadOk = 0;
    }

    // Check if file already exists
    if (file_exists($targetFile)) {
        echo "Sorry, file already exists.";
        $uploadOk = 0;
    }

    // Check file size
    if ($_FILES['faceImage']['size'] > 500000) {
        echo "Sorry, your file is too large.";
        $uploadOk = 0;
    }

    // Allow certain file formats
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
        && $imageFileType != "gif") {
        echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
        $uploadOk = 0;
    }

    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        echo "Sorry, your file was not uploaded.";
    // if everything is ok, try to upload file
    } else {
        if (move_uploaded_file($_FILES['faceImage']['tmp_name'], $targetFile)) {
            echo "The file ". basename( $_FILES['faceImage']['name']). " has been uploaded.";
            // Here you can store the file name or its path in your database along with other data if needed
            // For example, you can use $targetFile
            // Now you have $name for the person's name and $targetFile for the file name on the server
        } else {
            echo "Sorry, there was an error uploading your file.";
        }
    }
} else {
    echo "No file uploaded or there was an error with the upload.";
}
?>
