import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bom-approval',
  templateUrl: './bom-approval.component.html',
  styleUrls: ['./bom-approval.component.css']
})
export class BomApprovalComponent implements OnInit {

  isRecord = true;
  isShow = false;
  boms;
  selectedBOM = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getCheckedBOMs();
  }

  getCheckedBOMs() {
    this.service.get('production.php?type=getCheckedBOMs').subscribe(response => {
      this.boms = response;
      if (Object.keys(this.boms).length == 0) {
        this.isRecord = true;
      } else {
        this.isRecord = false;
      }
    });
  }

  viewBOM(index) {
    this.selectedBOM = this.boms[index];
    this.isShow = true;
  }

  updateCheckedBOM(action) {
    this.service.get('production.php?type=updateCheckedBOM&action=' + action + '&bom_no=' + this.selectedBOM['bom_no']).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('successfully saved');
      } else {
        alertify.error('An error occured');
      }
    });
  }
}
