import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bp-approval',
  templateUrl: './bp-approval.component.html',
  styleUrls: ['./bp-approval.component.css']
})
export class BpApprovalComponent implements OnInit {

  isRecord = true;
  entries;
  selectedData;
  isView = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlannings();
  }

  getBatchPlannings() {
    this.service.get('production.php?type=getCheckedBatchPlannings').subscribe(response => {
      this.entries = response;
      if (Object.keys(this.entries).length == 0) {
        this.isRecord = true;
      } else {
        this.isRecord = false;
      }
    });
  }

  viewData(index) {
    this.selectedData = this.entries[index];
    this.isView = true;
  }

  updateBatchPlanning(value) {
    this.service.get('production.php?type=updateCheckedBatchPlanning&no=' + this.selectedData['no'] + '&action=' + value).subscribe(response => {
      if (response['status'] === 'success') {
        this.getBatchPlannings();
        this.isView = false;
        alertify.success('Updated Successfully');
      } else {
        alertify.error('An error occured');
      }
    });
  }
}
