import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-batch-completed',
  templateUrl: './batch-completed.component.html',
  styleUrls: ['./batch-completed.component.css']
})
export class BatchCompletedComponent implements OnInit {

  products;
  results;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getBatchPlanningLog').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.isNew = true;
  }

}
