import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-batch-inprocess',
  templateUrl: './batch-inprocess.component.html',
  styleUrls: ['./batch-inprocess.component.css']
})
export class BatchInprocessComponent implements OnInit {

  products;
  results;
  selectedBMR = [];
  isNew = false;

  data = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getInprocessBatches').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.data = JSON.parse(this.selectedBMR['data']);
    this.isNew = true;
  }

  callforDispensing(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    this.data['status'] = 'inprocess';
    this.service.post('bmr.php?type=callforDispensing&bp_no=' + this.selectedBMR['no'] + '&stage=' + stage['id'], JSON.stringify(this.data)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Dispensing Request has been send to Store Department');
        this.isNew = false;
        this.getBatchPlanningLog();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
