import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
import { FormGroup, FormControl, Validators } from '@angular/forms';

@Component({
  selector: 'app-bill-of-materail',
  templateUrl: './bill-of-materail.component.html',
  styleUrls: ['./bill-of-materail.component.css']
})
export class BillOfMaterailComponent implements OnInit {

  isViewBOM = false;
  isNewBOM = false;
  users;
  products;
  mfr;
  materials;

  counter = Array;
  batch_size = 0;
  lot_no = 1;

  bomForm = new FormGroup({
    product_code: new FormControl('', Validators.required),
    batch_no: new FormControl('', Validators.required),
    batch_size: new FormControl('', Validators.required),
    lot_no: new FormControl('', Validators.required)
  });

  process = '';
  equipment_name = '';
  equipments;
  selectedEquipments = [];

  boms;
  selectedBOM;
  mf_no = '';

  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBOMs();
    this.getProducts();
    this.getEquipments();
  }

  getBOMs() {
    this.service.get('production.php?type=getBOMs').subscribe(response => {
      this.boms = response;
    });
  }

  getProducts() {
    this.service.get('qaDepartment.php?type=getApprovedProducts')
    .subscribe(response => {
      this.products = response;
    });
  }

  getEquipments() {
    this.service.get('qaDepartment.php?type=getEquipments')
    .subscribe(response => {
      this.equipments = response;
    });
  }

  getProductMFR(value) {
    this.service.get('rndDepartment.php?type=getProductMFR&product_code=' + value).subscribe(response => {
      this.mfr = response;
      this.mf_no = this.mfr[0].mfr_no;
      this.materials = this.mfr[0].materials;
    });
  }

  updateMaterial() {
    for (let i = 0; i < this.materials.length; i++) {
      let unit_qty = this.materials[i].qty;
      let std_qty = unit_qty * this.batch_size;
      let qty = (std_qty / 1000).toFixed(2);
      this.materials[i].std_qty = (+qty / this.lot_no).toFixed(2);
      this.materials[i].lot_no = i + 1;
    }
  }

  saveBOM() {
    let temp = this.bomForm.value;
    temp['mf_no'] = this.mf_no;
    temp['materials'] = this.materials;
    temp['equipments'] = this.selectedEquipments;

    this.service.post('production.php?type=saveBOM', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] === 'success') {
        this.materials = [];
        this.selectedEquipments = [];
        this.equipment_name = '';
        this.process = '';
        this.isNewBOM = false;
        this.bomForm.reset();
      } else {
        alert('error');
      }
    });
  }

  addEquipments() {
    if (this.equipment_name.length > 0) {
      let index = this.selectedEquipments.length;
      let temp = {};
      let i = +this.equipment_name;
      temp = this.equipments[i];
      temp['process'] = this.process;
      this.selectedEquipments[index] = temp;
      this.equipment_name = '';
      this.process = '';
    }
  }

  viewBOM(index) {
    this.isViewBOM = true;
    this.selectedBOM = this.boms[index];
  }
}
