import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

import { BmrRoutingModule } from './bmr-routing.module';
import { DashboardComponent } from './dashboard/dashboard.component';
import { ProcessLotsComponent } from './process-lots/process-lots.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ClarityModule } from '@clr/angular';
import { CompletedComponent } from './completed/completed.component';
import { PlannedComponent } from './planned/planned.component';
import { PlanComponent } from '../lmr/batch/plan/plan.component';
import { InprocessComponent } from './inprocess/inprocess.component';
import { MasterComponent } from './master/master.component';
import { YieldComponent } from './yield/yield.component';


@NgModule({
  declarations: [DashboardComponent, ProcessLotsComponent, CompletedComponent, PlannedComponent, InprocessComponent, MasterComponent, YieldComponent, PlanComponent],
  imports: [
    CommonModule,
    BmrRoutingModule,
    FormsModule,
    ReactiveFormsModule,
    ClarityModule
  ]
})
export class BmrModule { }
