import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-approval',
  templateUrl: './approval.component.html',
  styleUrls: ['./approval.component.css']
})
export class ApprovalComponent implements OnInit {

  isView = false;
  results;

  selectedResult = [];
  constructor(private service:DataAccessService) { }

  ngOnInit() {
    this.getPendingBatches();
  }

  getPendingBatches(){
    this.service.get('production/batch.php?type=getPendingBatches').subscribe(response => {
      this.results = response;
    });
  }

  view(index){
    this.selectedResult = this.results[index];
    this.isView = true;
  }

  update(status){
    this.service.get('production/batch.php?type=checkBatch&status=' + status + '&id=' + this.selectedResult['id']).subscribe(response => {
      if(response['status'] == 'success'){
        alertify.success('Data Updated Sucessfully!');
        this.isView = false;
        this.getPendingBatches();
      }else{
        alertify.error('Failed an error occured,Please try again!');
      }
    });
  }

}
