import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bom-checking',
  templateUrl: './bom-checking.component.html',
  styleUrls: ['./bom-checking.component.css']
})
export class BomCheckingComponent implements OnInit {

  isShow = false;
  boms;
  selectedBOM = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingBOMs();
  }

  getPendingBOMs() {
    this.service.get('production.php?type=getPendingBOMs').subscribe(response => {
      this.boms = response;
    });
  }

  viewBOM(index) {
    this.selectedBOM = this.boms[index];
    this.isShow = true;
  }

  updatePendingBOM(action) {
    this.service.get('production.php?type=updatePendingBOM&action=' + action + '&bom_no=' + this.selectedBOM['bom_no']).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('successfully saved');
      } else {
        alertify.error('An error occured');
      }
    });
  }

}
