import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  products;
  units;

  selectedResult = [];
  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit(): void {
    this.getUnits();
  }

  getProductsByDosage(value) {
    this.service.get('production/master.php?type=getProductsByDosage&product_type=' + value).subscribe(response => {
      this.products = response;
    });
  }

  getDetails(index) {
    index = index - 1;
    if (index !== -1) {
      this.selectedResult = this.products[index];
    }
  }

  getUnits() {
    this.service.get('common.php?type=getUnits').subscribe(response => {
      this.units = response;
    });
  }

  save(data) {
    if (!data.valid) {
      alertify.error('All fields are required!');
      return;
    }
    this.service.post('production/master.php?type=saveMaster', JSON.stringify(data.value)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Product MFR initiated successfully!');
        this.router.navigate(['/ebmr/master']);
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }

}
