import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-inprocess',
  templateUrl: './inprocess.component.html',
  styleUrls: ['./inprocess.component.css']
})
export class InprocessComponent implements OnInit {

  products;
  results;
  selectedResult = [];
  isNew = false;
  isBill=false;
  isunitView=false;
  data = [];
  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit() {
    this.getInprocessBatches();
  }

  getInprocessBatches() {
    this.service.get('production/inprocess.php?type=getInprocessBatches').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedResult = this.results[index];
    //this.data = JSON.parse(this.selectedBMR['data']);
    this.isNew = true;
  }

  work(id) {
    this.router.navigate(['/batch/work/' + id]);
  }

  viewUnit(){
    this.isunitView=true;
  }
  viewBill(){
    this.isBill=true;
  }

  stage(id, stage) {
    this.service.get('production/inprocess.php?type=startProduction&id=' + id).subscribe(response => {
      if (response['status'] == 'success') {
        this.router.navigate(['/lmr/batch/new/' + id]);
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }

  viewstage(id, stage) {
    this.router.navigate(['/lmr/batch/new/' + id]);
  }

  callforDispensing(index) {
    let stages = this.selectedResult['stages'];
    let stage = stages[index];
    this.data['status'] = 'inprocess';
    this.service.post('bmr.php?type=callforDispensing&bp_no=' + this.selectedResult['no'] + '&stage=' + stage['id'], JSON.stringify(this.data)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Dispensing Request has been send to Store Department');
        this.isNew = false;
        this.getInprocessBatches();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
