import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-lmr',
  templateUrl: './lmr.component.html',
  styleUrls: ['./lmr.component.css']
})
export class LmrComponent implements OnInit {

  results;
  isView=false;
  dosages;
  product;
  batch;
  status='';
  product_code='';
  dosage_form='';
  batch_size ='';
  selectedResult=[];
  constructor(private service:DataAccessService) { }

  ngOnInit() {
    this.getPendingBatchNos();
   // this.getDosages();
  }
  getPendingBatchNos(){
    this.service.get('production/plan.php?type=getPendingBatchNos').subscribe(response=>{
      this.results=response;
    });
  }

  view(index){
    this.selectedResult= this.results[index];
    this.isView =true;
  }
  
  update(status){
    this.service.get('production/plan.php?type=allocateBatchNo&id=' + this.selectedResult['id']).subscribe(response => {
      if(response['status'] == 'success'){
        alertify.success('Data Updated Successfully!');
        this.isView = false;
        this.getPendingBatchNos();
      }else{
        alertify.error('Failed an error occured,Please try again!');
      }
    });
  }

}
