import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-completed-lots',
  templateUrl: './completed-lots.component.html',
  styleUrls: ['./completed-lots.component.css']
})
export class CompletedLotsComponent implements OnInit {

  products;
  results;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getCompletedLots();
  }

  getCompletedLots() {
    this.service.get('bmr.php?type=getCompletedLots').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.isNew = true;
  }

}
